/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.serverbound;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record OpenCameraAttachmentsInCreativePacketC2SP(int cameraSlotIndex) implements Packet
{
    public static final ResourceLocation ID = Exposure.resource("open_camera_attachments");
    public static final CustomPacketPayload.Type<OpenCameraAttachmentsInCreativePacketC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, OpenCameraAttachmentsInCreativePacketC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, OpenCameraAttachmentsInCreativePacketC2SP::cameraSlotIndex, OpenCameraAttachmentsInCreativePacketC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow flow, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.server.execute(() -> {
                ItemStack stack = player.getInventory().getItem(this.cameraSlotIndex);
                Item patt0$temp = stack.getItem();
                if (patt0$temp instanceof CameraItem) {
                    CameraItem cameraItem = (CameraItem)patt0$temp;
                    cameraItem.openCameraAttachments(player, this.cameraSlotIndex, true);
                }
            });
        }
        return true;
    }
}

