/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.Exposure;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraData
extends CompoundTag {
    public static final Codec<ExtraData> CODEC = CompoundTag.CODEC.xmap(ExtraData::new, data -> data);
    public static final StreamCodec<ByteBuf, ExtraData> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(ExtraData::new, data -> data);
    public static final ExtraData EMPTY = new ExtraData(Collections.emptyMap());
    private final Map<String, Tag> tags;

    protected ExtraData(Map<String, Tag> tags) {
        super(tags);
        this.tags = tags;
    }

    public ExtraData() {
        this(new HashMap<String, Tag>());
    }

    public ExtraData(CompoundTag tag) {
        this(new HashMap<String, Tag>());
        this.merge(tag);
    }

    public <T> Optional<T> get(@NotNull Type<T> type) {
        if (!this.contains(type.key())) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(type.getter().apply(this, type.key()));
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot get ExtraData entry: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public <T> T getOrDefault(@NotNull Type<T> type, T defaultValue) {
        if (!this.contains(type.key())) {
            return defaultValue;
        }
        try {
            @Nullable T value = type.getter().apply(this, type.key());
            return value != null ? value : defaultValue;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot get ExtraData entry: {}", (Object)e.getMessage());
            return defaultValue;
        }
    }

    public <T> void put(Type<T> type, @NotNull T value) {
        Preconditions.checkNotNull(value, (Object)"value");
        type.setter().accept((Object)this, (Object)type.key(), value);
    }

    public <T> void remove(Type<T> type) {
        this.remove(type.key());
    }

    @NotNull
    public ExtraData copy() {
        HashMap map = Maps.newHashMap((Map)Maps.transformValues(this.tags, Tag::copy));
        return new ExtraData(map);
    }

    @NotNull
    public ExtraData merge(CompoundTag other) {
        for (String key : other.getAllKeys()) {
            Tag tag = other.get(key);
            assert (tag != null);
            if (tag.getId() == 10) {
                if (this.contains(key, 10)) {
                    CompoundTag compoundTag = this.getCompound(key);
                    compoundTag.merge((CompoundTag)tag);
                    continue;
                }
                this.put(key, tag.copy());
                continue;
            }
            this.put(key, tag.copy());
        }
        return this;
    }

    public record Type<T>(String key, BiFunction<ExtraData, String, @Nullable T> getter, TriConsumer<ExtraData, String, T> setter) {
        public static Type<String> string(String key) {
            return new Type<String>(key, CompoundTag::getString, CompoundTag::putString);
        }

        public static Type<Boolean> bool(String key) {
            return new Type<Boolean>(key, CompoundTag::getBoolean, CompoundTag::putBoolean);
        }

        public static Type<Integer> intVal(String key) {
            return new Type<Integer>(key, CompoundTag::getInt, CompoundTag::putInt);
        }

        public static Type<Long> longVal(String key) {
            return new Type<Long>(key, CompoundTag::getLong, CompoundTag::putLong);
        }

        public static Type<Float> floatVal(String key) {
            return new Type<Float>(key, CompoundTag::getFloat, CompoundTag::putFloat);
        }

        public static Type<Double> doubleVal(String key) {
            return new Type<Double>(key, CompoundTag::getDouble, CompoundTag::putDouble);
        }

        public static <T extends StringRepresentable> Type<T> stringRepresentable(String key, Function<String, @Nullable T> deserializeFunction) {
            return new Type<StringRepresentable>(key, (data, k) -> (StringRepresentable)deserializeFunction.apply(data.getString(k)), (data, k, value) -> data.putString(k, value.getSerializedName()));
        }

        public static Type<Vec3> vec3(String key) {
            return new Type<Vec3>(key, (data, k) -> {
                ListTag pos = data.getList(k, 6);
                return new Vec3(pos.getDouble(0), pos.getDouble(1), pos.getDouble(2));
            }, (data, k, value) -> {
                ListTag pos = new ListTag();
                pos.add((Object)DoubleTag.valueOf((double)value.x()));
                pos.add((Object)DoubleTag.valueOf((double)value.y()));
                pos.add((Object)DoubleTag.valueOf((double)value.z()));
                data.put(k, (Tag)pos);
            });
        }

        public static Type<ResourceLocation> resourceLocation(String key) {
            return new Type<ResourceLocation>(key, (data, k) -> ResourceLocation.parse((String)data.getString(k)), (data, k, value) -> data.putString(k, value.toString()));
        }

        public static <T> Type<List<T>> list(String key, int tagType, Function<Tag, T> extractFunc, Function<T, Tag> packFunc) {
            return new Type<List<T>>(key, (data, k) -> data.getList(k, tagType).stream().map(extractFunc).toList(), (data, k, value) -> {
                ListTag list = new ListTag();
                list.addAll(value.stream().map(packFunc).toList());
                data.put(k, (Tag)list);
            });
        }

        public static <T> Type<List<T>> stringBasedList(String key, Function<String, T> extractFunc, Function<T, String> packFunc) {
            return Type.list(key, 8, tag -> extractFunc.apply(tag.getAsString()), value -> StringTag.valueOf((String)((String)packFunc.apply(value))));
        }
    }
}

