/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera;

import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.network.packet.clientbound.ActiveCameraInHandSetS2CP;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CameraInHand
extends Camera {
    protected final InteractionHand hand;

    public CameraInHand(CameraHolder holder, CameraId cameraId, InteractionHand hand) {
        super(holder, cameraId);
        this.hand = hand;
        if (!(holder instanceof LivingEntity)) {
            throw new IllegalStateException("Only LivingEntity can hold camera in hand." + String.valueOf(EntityType.getKey((EntityType)holder.asHolderEntity().getType())) + " does snot have hands.");
        }
    }

    @Override
    public ItemStack getItemStack() {
        return ((LivingEntity)this.getHolder()).getItemInHand(this.getHand());
    }

    @Override
    public boolean deactivate() {
        CameraItem cameraItem;
        Object object;
        if (super.deactivate()) {
            return true;
        }
        InteractionHand oppositeHand = this.getHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack itemInHand = ((LivingEntity)this.getHolder()).getItemInHand(oppositeHand);
        if (this.getId().matches(itemInHand) && (object = itemInHand.getItem()) instanceof CameraItem && (cameraItem = (CameraItem)((Object)object)).isActive(itemInHand)) {
            cameraItem.deactivate(this.getHolder().asHolderEntity(), itemInHand);
            return true;
        }
        object = this.getHolder();
        if (object instanceof Player) {
            Player player = (Player)object;
            for (ItemStack stack : player.getInventory().items) {
                CameraItem cameraItem2;
                Item item;
                if (!this.getId().matches(stack) || !((item = stack.getItem()) instanceof CameraItem) || !(cameraItem2 = (CameraItem)item).isActive(stack)) continue;
                cameraItem2.deactivate(this.getHolder().asHolderEntity(), stack);
                return true;
            }
        }
        return false;
    }

    @Override
    public Packet createSyncPacket() {
        return new ActiveCameraInHandSetS2CP(this.getHolder().asHolderEntity().getId(), this.getId(), this.getHand());
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    @Nullable
    public static CameraInHand find(CameraHolder holder) {
        InteractionHand[] interactionHandArray = holder.asHolderEntity();
        if (interactionHandArray instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)interactionHandArray;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack itemInHand = entity.getItemInHand(hand);
                Item item = itemInHand.getItem();
                if (!(item instanceof CameraItem)) continue;
                CameraItem cameraItem = (CameraItem)item;
                return new CameraInHand(holder, cameraItem.getOrCreateId(itemInHand), hand);
            }
        }
        return null;
    }
}

