/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.film.properties;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.util.Codecs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ColorBalance(float r, float g, float b) {
    public static final ColorBalance EMPTY = new ColorBalance(0.0f, 0.0f, 0.0f);
    public static final Codec<ColorBalance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("red", (Object)Float.valueOf(0.0f)).forGetter(ColorBalance::r), (App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("green", (Object)Float.valueOf(0.0f)).forGetter(ColorBalance::g), (App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("blue", (Object)Float.valueOf(0.0f)).forGetter(ColorBalance::b)).apply((Applicative)instance, ColorBalance::new));
    public static final StreamCodec<FriendlyByteBuf, ColorBalance> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, ColorBalance::r, (StreamCodec)ByteBufCodecs.FLOAT, ColorBalance::g, (StreamCodec)ByteBufCodecs.FLOAT, ColorBalance::b, ColorBalance::new);

    public ColorBalance {
        Preconditions.checkArgument((r >= -1.0f && r <= 1.0f ? 1 : 0) != 0, (Object)"r must be in -1 to 1 range.");
        Preconditions.checkArgument((g >= -1.0f && g <= 1.0f ? 1 : 0) != 0, (Object)"g must be in -1 to 1 range.");
        Preconditions.checkArgument((b >= -1.0f && b <= 1.0f ? 1 : 0) != 0, (Object)"b must be in -1 to 1 range.");
    }

    @Override
    public String toString() {
        return "R:%s, G:%s, B:%s".formatted(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }
}

