/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.experience;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createdragonsplus.common.fluids.pipe.ConsumingOpenPipeEffectHandler;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIAdvancements;

public class ExperienceEffectHandler
implements ConsumingOpenPipeEffectHandler {
    public int consume(Level level, AABB area, FluidStack contained) {
        if (!(level instanceof ServerLevel)) {
            return 0;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int amount = contained.getAmount();
        List players = level.getEntitiesOfClass(ServerPlayer.class, area, player -> !player.isFakePlayer());
        if (players.isEmpty()) {
            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)area.getCenter(), (int)ExperienceHelper.getExperienceFromFluid(contained));
        } else {
            ServerPlayer player2 = (ServerPlayer)players.get(level.random.nextInt(players.size()));
            ExperienceHelper.award(amount, player2);
            CEIAdvancements.A_SHOWER_EXPERIENCE.awardTo((Player)player2);
        }
        return amount;
    }

    public void apply(Level level, AABB area, FluidStack fluid) {
    }
}

