/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.experience;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;

public class ExperienceHelper {
    public static int getExperienceForNextLevel(int level) {
        if (level >= 30) {
            return 9 * level - 158;
        }
        if (level >= 15) {
            return 5 * level - 38;
        }
        return 2 * level + 7;
    }

    public static int getExperienceForTotalLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level >= 31) {
            return (9 * level * level - 325 * level) / 2 + 2220;
        }
        if (level >= 16) {
            return (5 * level * level - 91 * level) / 2 + 360;
        }
        return level * level + 6 * level;
    }

    public static int getExperienceForPlayer(Player player) {
        int experience = ExperienceHelper.getExperienceForTotalLevel(player.experienceLevel);
        return experience += Math.round(player.experienceProgress * (float)ExperienceHelper.getExperienceForNextLevel(player.experienceLevel));
    }

    public static int getExperienceFromFluid(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return 0;
        }
        if (fluid.is(CEIFluids.EXPERIENCE)) {
            return fluid.getAmount();
        }
        int amount = fluid.getAmount();
        Integer unit = (Integer)fluid.getFluidHolder().getData(CEIDataMaps.FLUID_UNIT_EXPERIENCE);
        if (unit == null) {
            return 0;
        }
        return amount / unit;
    }

    public static int getFluidFromExperience(FluidStack fluid, int amount) {
        return ExperienceHelper.getFluidFromExperience((Holder<Fluid>)fluid.getFluidHolder(), amount);
    }

    public static int getFluidFromExperience(Holder<Fluid> fluid, int amount) {
        return ExperienceHelper.getExperienceFluidUnit(fluid) * amount;
    }

    public static int getExperienceFluidUnit(Holder<Fluid> fluid) {
        if (fluid.equals(CEIFluids.EXPERIENCE)) {
            return 1;
        }
        Integer unit = (Integer)fluid.getData(CEIDataMaps.FLUID_UNIT_EXPERIENCE);
        return unit == null ? 0 : unit;
    }

    public static void award(int amount, ServerPlayer player) {
        amount = ExperienceHelper.repairPlayerItems(player, amount);
        player.giveExperiencePoints(amount);
    }

    public static boolean canRepairItem(ItemStack stack) {
        if (!stack.isDamaged()) {
            return false;
        }
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (lookup == null) {
            return false;
        }
        ItemEnchantments enchantments = stack.getAllEnchantments(lookup);
        for (Holder enchantment : enchantments.keySet()) {
            if (!((Enchantment)enchantment.value()).effects().has(EnchantmentEffectComponents.REPAIR_WITH_XP)) continue;
            return true;
        }
        return false;
    }

    public static int repairItem(int amount, ServerLevel level, ItemStack stack, boolean simulate) {
        int repairing = EnchantmentHelper.modifyDurabilityToRepairFromXp((ServerLevel)level, (ItemStack)stack, (int)((int)((float)amount * stack.getXpRepairRatio())));
        int repaired = Math.min(repairing, stack.getDamageValue());
        if (repaired == 0) {
            return 0;
        }
        if (!simulate) {
            stack.setDamageValue(stack.getDamageValue() - repaired);
        }
        return Math.max(1, repaired * amount / repairing);
    }

    public static int repairPlayerItems(ServerPlayer player, int amount) {
        Optional optional = EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, (LivingEntity)player, ItemStack::isDamaged);
        if (optional.isPresent()) {
            ItemStack stack = ((EnchantedItemInUse)optional.get()).itemStack();
            int consumed = ExperienceHelper.repairItem(amount, player.serverLevel(), stack, false);
            return amount > consumed ? ExperienceHelper.repairPlayerItems(player, amount - consumed) : 0;
        }
        return amount;
    }
}

