/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.enchanter;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.api.visualization.VisualizationLevel;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.BlazeEnchanterBlockEntity;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.behaviour.EnchantingBehaviour;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.behaviour.TemplateEnchantingBehaviour;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class EnchanterBehaviour
extends ScrollValueBehaviour
implements IHaveGoggleInformation {
    public static final BehaviourType<EnchanterBehaviour> TYPE = new BehaviourType();
    public static final String LEVEL = "EnchantingLevel";
    public static final String TEMPLATE = "EnchantingTemplate";
    private final BlazeEnchanterBlockEntity enchanter;
    private ItemStack template = ItemStack.EMPTY;
    private EnchantingBehaviour enchanting = new EnchantingBehaviour();
    ValueBoxTransform.Sided templateItemTransform;

    public EnchanterBehaviour(BlazeEnchanterBlockEntity enchanter, ValueBoxTransform transform, ValueBoxTransform.Sided templateItemTransform) {
        super((Component)CEILang.translate("gui.blaze_enchanter.level", new Object[0]).component(), (SmartBlockEntity)enchanter, transform);
        this.enchanter = enchanter;
        this.templateItemTransform = templateItemTransform;
    }

    public ValueBoxTransform getTemplateItemSlotPositioning() {
        return this.templateItemTransform;
    }

    public boolean canProcess(ItemStack stack) {
        return this.enchanting.canProcess(this.getWorld(), stack, this.enchanter.special);
    }

    public float getRenderDistance() {
        return AllConfigs.client().filterItemRenderDistance.getF();
    }

    public void update(ItemStack stack) {
        this.enchanting.update(this.getWorld(), stack, this.value, this.enchanter.special, this.enchanter.cursed);
    }

    public ItemStack getResult(ItemStack stack) {
        return this.enchanting.getResult(this.getWorld(), stack, this.enchanter.getRandom(), this.enchanter.special);
    }

    public int getExperienceCost() {
        return this.enchanting.getExperienceCost();
    }

    public ItemStack getTemplate() {
        return this.template;
    }

    public boolean setTemplate(ItemStack stack) {
        if (stack.isEmpty()) {
            this.template = ItemStack.EMPTY;
            this.enchanting = new EnchantingBehaviour();
        } else if (stack.isEnchantable()) {
            this.template = stack;
            this.enchanting = new TemplateEnchantingBehaviour(this.template);
        } else {
            return false;
        }
        this.update(this.enchanter.heldItem);
        Level level = this.getWorld();
        if (!(level instanceof VisualizationLevel)) {
            this.blockEntity.setChanged();
            this.blockEntity.sendData();
        }
        return true;
    }

    public void setValue(int value) {
        if ((value = Mth.clamp((int)value, (int)0, (int)this.enchanter.getMaxEnchantLevel())) == this.value) {
            return;
        }
        this.value = value;
        this.update(this.enchanter.heldItem);
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        int max = this.enchanter.getMaxEnchantLevel();
        return new ValueSettingsBoard(this.label, max, max / 6, (List)ImmutableList.of((Object)this.label), new ValueSettingsFormatter(ValueSettingsBehaviour.ValueSettings::format));
    }

    public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
        ItemStack stack = player.getItemInHand(hand);
        if (AllItems.WRENCH.isIn(stack)) {
            return;
        }
        if (AllBlocks.MECHANICAL_ARM.isIn(stack)) {
            return;
        }
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        if (stack.isEmpty()) {
            this.setTemplate(ItemStack.EMPTY);
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
            return;
        }
        if (!this.setTemplate(stack.copyWithCount(1))) {
            player.displayClientMessage((Component)CEILang.translate("gui.blaze_enchanter.template.invalid", new Object[0]).component(), true);
            AllSoundEvents.DENY.playOnServer(player.level(), (Vec3i)player.blockPosition(), 1.0f, 1.0f);
            return;
        }
        level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        nbt.putInt(LEVEL, this.value);
        nbt.put(TEMPLATE, this.template.saveOptional(registries));
    }

    public void writeSafe(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putInt(LEVEL, this.value);
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        this.value = Math.clamp((long)nbt.getInt(LEVEL), 0, this.enchanter.getMaxEnchantLevel());
        this.template = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound(TEMPLATE));
        Level level = this.getWorld();
        if (level != null) {
            this.setTemplate(this.template);
        }
    }

    public void initialize() {
        this.setTemplate(this.template);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ChatFormatting style;
        boolean added = false;
        if (!this.template.isEmpty()) {
            CEILang.translate("gui.goggles.enchanting.template", new Object[0]).forGoggles(tooltip);
            CEILang.item(this.template).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            added = true;
        }
        ChatFormatting chatFormatting = this.enchanter.special ? (this.enchanter.cursed ? ChatFormatting.RED : ChatFormatting.BLUE) : (style = ChatFormatting.GOLD);
        if (this.value > 0) {
            CEILang.translate("gui.goggles.enchanting.level", CEILang.number(this.value).style(style)).forGoggles(tooltip);
            added = true;
        } else {
            CEILang.translate("gui.goggles.enchanting.level.not_set", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
        }
        int cost = this.getExperienceCost();
        if (cost > 0) {
            LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
            CEILang.translate("gui.goggles.enchanting.cost", CEILang.number(cost).add(mb).style(style)).forGoggles(tooltip);
            added = true;
        }
        if (!this.enchanter.heldItem.isEmpty() && this.enchanter.processingTime == -1) {
            if (!EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)this.enchanter.heldItem).isEmpty()) {
                CEILang.translate("gui.goggles.enchanting.completed", new Object[0]).style(ChatFormatting.GREEN).forGoggles(tooltip);
            } else {
                CEILang.translate("gui.goggles.enchanting.invalid_item", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
            }
        }
        return added;
    }
}

