/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.integration.jei.category.printing;

import com.mojang.serialization.MapCodec;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeFluidType;
import plus.dragons.createdragonsplus.common.registry.CDPFluids;
import plus.dragons.createdragonsplus.util.Pairs;
import plus.dragons.createenchantmentindustry.common.CEICommon;
import plus.dragons.createenchantmentindustry.common.registry.CEIDataMaps;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.PrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.util.CEILang;

public enum BannerPatternPrintingRecipeJEI implements PrintingRecipeJEI
{
    INSTANCE;

    public static final PrintingRecipeJEI.Type TYPE;

    @Override
    public void setBase(IRecipeSlotBuilder slot) {
        slot.addIngredients(Ingredient.of((TagKey)ItemTags.BANNERS));
        slot.addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)CEILang.translate("recipe.printing.banner_pattern.base", new Object[0]).style(ChatFormatting.GRAY).component()));
    }

    @Override
    public void setTemplate(IRecipeSlotBuilder slot) {
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        ((HolderLookup.RegistryLookup)registryAccess.lookup(Registries.BANNER_PATTERN).get()).listElements().forEach(element -> {
            ItemStack stack = new ItemStack((ItemLike)Items.WHITE_BANNER);
            ArrayList<BannerPatternLayers.Layer> l = new ArrayList<BannerPatternLayers.Layer>();
            l.add(new BannerPatternLayers.Layer(element.getDelegate(), DyeColor.BLACK));
            stack.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(l));
            slot.addItemStack(stack);
        });
        slot.addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)CEILang.translate("recipe.printing.banner_pattern.template", new Object[0]).style(ChatFormatting.GRAY).component()));
    }

    @Override
    public void setFluid(IRecipeSlotBuilder slot) {
        CEIDataMaps.getSourceFluidEntries(CEIDataMaps.PRINTING_BANNER_PATTERN_INGREDIENT).forEach(Pairs.accept((arg_0, arg_1) -> ((IRecipeSlotBuilder)slot).addFluidStack(arg_0, arg_1)));
    }

    @Override
    public void setOutput(IRecipeSlotBuilder slot) {
        slot.addItemLike((ItemLike)Items.WHITE_BANNER);
        slot.addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)CEILang.translate("recipe.printing.banner_pattern.color_follow_dye", new Object[0]).style(ChatFormatting.GRAY).component()));
    }

    @Override
    public PrintingRecipeJEI.Type getType() {
        return TYPE;
    }

    @Override
    public void onDisplayedIngredientsUpdate(IRecipeSlotDrawable baseSlot, IRecipeSlotDrawable templateSlot, IRecipeSlotDrawable fluidSlot, IRecipeSlotDrawable outputSlot, IFocusGroup focuses) {
        FluidStack fluid = fluidSlot.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK).orElse(new FluidStack((Fluid)((FluidEntry)CDPFluids.DYES_BY_COLOR.get(DyeColor.BLACK)).get(), 100));
        Optional base = baseSlot.getDisplayedItemStack();
        Optional template = templateSlot.getDisplayedItemStack();
        ItemStack output = ((ItemStack)base.get()).copy();
        ArrayList<BannerPatternLayers.Layer> l = new ArrayList<BannerPatternLayers.Layer>();
        BannerPatternLayers pattern = (BannerPatternLayers)((ItemStack)template.get()).get(DataComponents.BANNER_PATTERNS);
        l.add(new BannerPatternLayers.Layer(((BannerPatternLayers.Layer)pattern.layers().getFirst()).pattern(), ((DyeFluidType)fluid.getFluidType()).getColor()));
        output.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(l));
        outputSlot.createDisplayOverrides().addItemStack(output);
    }

    static {
        TYPE = PrintingRecipeJEI.register(CEICommon.asResource("banner_pattern"), (MapCodec<? extends PrintingRecipeJEI>)MapCodec.unit((Object)INSTANCE));
    }
}

