/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.integration.tlm;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

public class MaidExperienceHandler {
    public static int drainMaidExperience(Level level, AABB effectiveAABB, IFluidHandler fluidHandler) {
        Integer rate = (Integer)CEIConfig.fluids().experienceLanternDrainRate.get();
        List maids = level.getEntitiesOfClass(EntityMaid.class, effectiveAABB, maid -> maid.isAlive() && maid.getExperience() > 0);
        if (maids.isEmpty()) {
            return 0;
        }
        AtomicInteger totalDrained = new AtomicInteger();
        AtomicInteger sum = new AtomicInteger();
        maids.forEach(maid -> {
            int maidExp = maid.getExperience();
            if (maidExp >= rate) {
                sum.addAndGet(rate);
            } else if (maidExp > 0) {
                sum.addAndGet(maidExp);
            }
        });
        if (sum.get() == 0) {
            return 0;
        }
        int inserted = fluidHandler.fill(new FluidStack(CEIFluids.EXPERIENCE, sum.get()), IFluidHandler.FluidAction.EXECUTE);
        if (inserted > 0) {
            int remaining = inserted;
            for (EntityMaid maid2 : maids) {
                if (remaining <= 0) break;
                int maidExp = maid2.getExperience();
                int toDrain = remaining >= rate ? Math.min(maidExp, rate) : Math.min(maidExp, remaining);
                if (toDrain <= 0) continue;
                maid2.setExperience(maidExp - toDrain);
                remaining -= toDrain;
                totalDrained.addAndGet(toDrain);
            }
        }
        return totalDrained.get();
    }
}

