/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;

public final class ItemStackKey {
    private final ItemStack stack;
    private static final Map<ItemStack, ItemStackKey> CACHE = new ConcurrentHashMap<ItemStack, ItemStackKey>();
    private boolean hashInitialized = false;
    private int hash;

    public static ItemStackKey of(ItemStack stack) {
        return CACHE.computeIfAbsent(stack, ItemStackKey::new);
    }

    private ItemStackKey(ItemStack stack) {
        this.stack = stack.copy();
        this.stack.setCount(1);
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackKey that = (ItemStackKey)o;
        return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)that.stack);
    }

    public boolean hashCodeNotEquals(ItemStack otherStack) {
        return this.hashCode() != ItemStack.hashItemAndComponents((ItemStack)otherStack);
    }

    public int hashCode() {
        if (!this.hashInitialized) {
            this.hashInitialized = true;
            this.hash = ItemStack.hashItemAndComponents((ItemStack)this.stack);
        }
        return this.hash;
    }

    public boolean matches(ItemStack stack) {
        return this.hashCode() == ItemStack.hashItemAndComponents((ItemStack)stack);
    }

    public ItemStack stack() {
        return this.stack;
    }

    public String toString() {
        return "ItemStackKey[stack=" + String.valueOf(this.stack) + "]";
    }
}

