/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.PlayDiscPayload;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StopDiscPlaybackPayload;

public class ServerStorageSoundHandler {
    private static final int KEEP_ALIVE_CHECK_INTERVAL = 10;
    private static final Map<ResourceKey<Level>, Long> lastWorldCheck = new HashMap<ResourceKey<Level>, Long>();
    private static final Map<ResourceKey<Level>, Map<UUID, SoundInfo>> worldStorageSoundInfos = new HashMap<ResourceKey<Level>, Map<UUID, SoundInfo>>();

    private ServerStorageSoundHandler() {
    }

    public static void tick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ResourceKey dim = serverLevel.dimension();
        if (!worldStorageSoundInfos.containsKey(dim)) {
            return;
        }
        ServerStorageSoundHandler.removeFinished(serverLevel, (ResourceKey<Level>)dim);
        if (lastWorldCheck.computeIfAbsent((ResourceKey<Level>)dim, key -> serverLevel.getGameTime()) > serverLevel.getGameTime() - 10L) {
            return;
        }
        lastWorldCheck.put((ResourceKey<Level>)dim, serverLevel.getGameTime());
        worldStorageSoundInfos.get(dim).entrySet().removeIf(entry -> {
            if (((SoundInfo)entry.getValue()).getLastKeepAliveTime() < serverLevel.getGameTime() - 10L) {
                ServerStorageSoundHandler.sendStopMessage((Level)serverLevel, ((SoundInfo)entry.getValue()).getLastPosition(), (UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    private static void removeFinished(ServerLevel serverLevel, ResourceKey<Level> dim) {
        ArrayList storageIdsToRemove = new ArrayList();
        worldStorageSoundInfos.get(dim).forEach((storageId, soundInfo) -> {
            if (soundInfo.getFinishTime() <= serverLevel.getGameTime()) {
                storageIdsToRemove.add(storageId);
            }
        });
        storageIdsToRemove.forEach(storageId -> ServerStorageSoundHandler.removeSoundInfo((Level)serverLevel, storageId, true));
    }

    public static void updateKeepAlive(UUID storageUuid, Level level, Vec3 position, Runnable onNoLongerRunning) {
        ResourceKey dim = level.dimension();
        if (!worldStorageSoundInfos.containsKey(dim) || !worldStorageSoundInfos.get(dim).containsKey(storageUuid)) {
            onNoLongerRunning.run();
            return;
        }
        if (worldStorageSoundInfos.get(dim).containsKey(storageUuid)) {
            worldStorageSoundInfos.get(dim).get(storageUuid).update(level.getGameTime(), position);
        }
    }

    public static void startPlayingDisc(ServerLevel serverLevel, BlockPos position, UUID storageUuid, Holder<JukeboxSong> song, Runnable onFinishedHandler) {
        Vec3 pos = Vec3.atCenterOf((Vec3i)position);
        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)pos.x, (double)pos.y, (double)pos.z, (double)128.0, (CustomPacketPayload)new PlayDiscPayload(storageUuid, song, position), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ServerStorageSoundHandler.putSoundInfo(serverLevel, storageUuid, onFinishedHandler, pos, serverLevel.getGameTime() + (long)((JukeboxSong)song.value()).lengthInTicks());
    }

    public static void startPlayingDisc(ServerLevel serverLevel, Vec3 position, UUID storageUuid, int entityId, Holder<JukeboxSong> song, Runnable onStopHandler) {
        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)position.x(), (double)position.y(), (double)position.z(), (double)128.0, (CustomPacketPayload)new PlayDiscPayload(storageUuid, song, entityId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ServerStorageSoundHandler.putSoundInfo(serverLevel, storageUuid, onStopHandler, position, serverLevel.getGameTime() + (long)((JukeboxSong)song.value()).lengthInTicks());
    }

    public static void putSoundInfo(ServerLevel serverLevel, UUID storageUuid, Runnable onFinishedHandler, Vec3 pos, long finishTime) {
        worldStorageSoundInfos.computeIfAbsent((ResourceKey<Level>)serverLevel.dimension(), dim -> new HashMap()).put(storageUuid, new SoundInfo(onFinishedHandler, serverLevel.getGameTime(), pos, finishTime));
    }

    public static void stopPlayingDisc(Level level, Vec3 position, UUID storageUuid) {
        ServerStorageSoundHandler.removeSoundInfo(level, storageUuid, false);
        ServerStorageSoundHandler.sendStopMessage(level, position, storageUuid);
    }

    private static void removeSoundInfo(Level level, UUID storageUuid, boolean finished) {
        ResourceKey dim = level.dimension();
        if (worldStorageSoundInfos.containsKey(dim) && worldStorageSoundInfos.get(dim).containsKey(storageUuid)) {
            SoundInfo soundInfo = worldStorageSoundInfos.get(dim).remove(storageUuid);
            if (finished) {
                soundInfo.runOnFinished();
            }
        }
    }

    private static void sendStopMessage(Level level, Vec3 position, UUID storageUuid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)position.x(), (double)position.y(), (double)position.z(), (double)128.0, (CustomPacketPayload)new StopDiscPlaybackPayload(storageUuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void onWorldUnload(LevelEvent.Unload evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        worldStorageSoundInfos.remove(serverLevel.dimension());
        lastWorldCheck.remove(serverLevel.dimension());
    }

    private static class SoundInfo {
        private final WeakReference<Runnable> onFinishedHandler;
        private long lastKeepAliveTime;
        private Vec3 lastPosition;
        private final long finishTime;

        private SoundInfo(Runnable onFinishedHandler, long lastKeepAliveTime, Vec3 lastPosition, long finishTime) {
            this.onFinishedHandler = new WeakReference<Runnable>(onFinishedHandler);
            this.lastKeepAliveTime = lastKeepAliveTime;
            this.lastPosition = lastPosition;
            this.finishTime = finishTime;
        }

        public long getLastKeepAliveTime() {
            return this.lastKeepAliveTime;
        }

        public Vec3 getLastPosition() {
            return this.lastPosition;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public void update(long gameTime, Vec3 position) {
            this.lastKeepAliveTime = gameTime;
            this.lastPosition = position;
        }

        public void runOnFinished() {
            Runnable handler = (Runnable)this.onFinishedHandler.get();
            if (handler != null) {
                handler.run();
            }
        }
    }
}

