/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.Slot;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.client.CuriosClientConfig;
import top.theillusivec4.curios.client.gui.CuriosButton;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.common.network.client.CPacketDestroy;

public class GuiEventHandler {
    @SubscribeEvent
    public void onInventoryGuiInit(ScreenEvent.Init.Post evt) {
        Screen screen = evt.getScreen();
        if (!((Boolean)CuriosClientConfig.CLIENT.enableButton.get()).booleanValue()) {
            return;
        }
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            boolean isCreative = screen instanceof CreativeModeInventoryScreen;
            Tuple<Integer, Integer> offsets = CuriosScreen.getButtonOffset(isCreative);
            int x = (Integer)offsets.getA();
            int y = (Integer)offsets.getB();
            int size = isCreative ? 8 : 10;
            int yOffset = isCreative ? 67 : 81;
            evt.addListener((GuiEventListener)new CuriosButton(gui, gui.getGuiLeft() + x - 2, gui.getGuiTop() + y + yOffset, size, size, isCreative ? CuriosButton.SMALL : CuriosButton.BIG));
        }
    }

    @SubscribeEvent
    public void onInventoryGuiDrawBackground(ScreenEvent.Render.Pre evt) {
        Screen screen = evt.getScreen();
        if (!(screen instanceof InventoryScreen)) {
            return;
        }
        InventoryScreen gui = (InventoryScreen)screen;
        gui.xMouse = evt.getMouseX();
        gui.yMouse = evt.getMouseY();
    }

    @SubscribeEvent
    public void onMouseClick(ScreenEvent.MouseButtonPressed.Pre evt) {
        CreativeModeInventoryScreen gui;
        block6: {
            block5: {
                long handle = Minecraft.getInstance().getWindow().getWindow();
                boolean isLeftShiftDown = InputConstants.isKeyDown((long)handle, (int)340);
                boolean isRightShiftDown = InputConstants.isKeyDown((long)handle, (int)344);
                boolean isShiftDown = isLeftShiftDown || isRightShiftDown;
                Screen screen = evt.getScreen();
                if (!(screen instanceof CreativeModeInventoryScreen)) break block5;
                gui = (CreativeModeInventoryScreen)screen;
                if (isShiftDown) break block6;
            }
            return;
        }
        if (!gui.isInventoryOpen()) {
            return;
        }
        Slot destroyItemSlot = gui.destroyItemSlot;
        Slot slot = gui.findSlot(evt.getMouseX(), evt.getMouseY());
        if (destroyItemSlot != null && slot == destroyItemSlot) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CPacketDestroy(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

