/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.renderer.replaced;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import tech.thatgravyboat.creeperoverhaul.client.renderer.replaced.ReplacedCreeperGlowLayer;
import tech.thatgravyboat.creeperoverhaul.client.renderer.replaced.ReplacedCreeperModel;
import tech.thatgravyboat.creeperoverhaul.client.renderer.replaced.ReplacedCreeperPowerLayer;
import tech.thatgravyboat.creeperoverhaul.common.entity.ReplacedCreeper;

public class ReplacedCreeperRenderer
extends GeoReplacedEntityRenderer<Creeper, ReplacedCreeper> {
    public ReplacedCreeperRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new ReplacedCreeperModel(), (GeoAnimatable)new ReplacedCreeper());
        this.addRenderLayer(new ReplacedCreeperGlowLayer(this));
        this.addRenderLayer(new ReplacedCreeperPowerLayer(this));
    }

    public void preRender(PoseStack stack, ReplacedCreeper animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        super.preRender(stack, (GeoAnimatable)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        float f = ((Creeper)this.currentEntity).getSwelling(partialTick);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f = f * f * (f * f);
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        stack.scale(f2, f3, f2);
    }

    public void render(Creeper entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isInvisible()) {
            return;
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public int getPackedOverlay(ReplacedCreeper animatable, float u, float partialTick) {
        return super.getPackedOverlay((GeoAnimatable)animatable, this.getSwellOverlay((Creeper)this.currentEntity, partialTick), partialTick);
    }

    protected float getSwellOverlay(Creeper creeper, float partialTicks) {
        float f = creeper.getSwelling(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    public RenderType getRenderType(ReplacedCreeper animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }

    public boolean shouldShowName(@NotNull Creeper entity) {
        if (this.currentEntity == null) {
            return false;
        }
        return super.shouldShowName((Entity)entity);
    }
}

