/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.thatgravyboat.creeperoverhaul.api.PluginRegistry;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.NeutralCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.PassiveCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperAvoidEntitiesGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperMeleeAttackGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperSwellGoal;
import tech.thatgravyboat.creeperoverhaul.common.utils.AnimationConstants;
import tech.thatgravyboat.creeperoverhaul.common.utils.PlatformUtils;

public class BaseCreeper
extends Creeper
implements GeoEntity,
Shearable {
    private static final EntityDataAccessor<Boolean> DATA_IS_ATTACKING = SynchedEntityData.defineId(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_SHEARED = SynchedEntityData.defineId(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    public final CreeperType type;

    public BaseCreeper(EntityType<? extends Creeper> entityType, Level level, CreeperType type) {
        super(entityType, level);
        this.type = type;
        if (!level.isClientSide) {
            this.type.entities().forEach(e -> this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, e, true)));
        }
    }

    public static EntityType.EntityFactory<BaseCreeper> of(CreeperType type) {
        return (entityType, level) -> new BaseCreeper((EntityType<? extends Creeper>)entityType, level, type);
    }

    public static EntityType.EntityFactory<PassiveCreeper> ofPassive(CreeperType type) {
        return (entityType, level) -> new PassiveCreeper((EntityType<? extends NeutralCreeper>)entityType, level, type);
    }

    public static EntityType.EntityFactory<NeutralCreeper> ofNeutral(CreeperType type) {
        return (entityType, level) -> new NeutralCreeper((EntityType<? extends NeutralCreeper>)entityType, level, type);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new CreeperSwellGoal(this));
        this.goalSelector.addGoal(3, (Goal)new CreeperAvoidEntitiesGoal(this, 6.0f, 1.0, 1.2));
        this.registerMovementGoals();
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerAttackGoals();
        if (this.shouldRevenge()) {
            this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        }
    }

    protected void registerAttackGoals() {
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> PluginRegistry.getInstance().canAttack(this, (LivingEntity)entity)));
        this.goalSelector.addGoal(4, (Goal)new CreeperMeleeAttackGoal(this, 1.0, false));
    }

    protected void registerMovementGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_ATTACKING, (Object)false);
        builder.define(DATA_IS_SHEARED, (Object)false);
    }

    public boolean isAttacking() {
        return (Boolean)this.getEntityData().get(DATA_IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.getEntityData().set(DATA_IS_ATTACKING, (Object)attacking);
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(DATA_IS_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.getEntityData().set(DATA_IS_SHEARED, (Object)sheared);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sheared", this.isSheared());
        tag.putShort("Fuse", (short)this.maxSwell);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSheared(tag.getBoolean("Sheared"));
        if (tag.contains("Fuse", 99)) {
            this.maxSwell = tag.getShort("Fuse");
        }
    }

    public boolean causeFallDamage(float f, float g, @NotNull DamageSource source) {
        boolean bl = super.causeFallDamage(f, g, source);
        this.swell += (int)(f * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return bl;
    }

    public void tick() {
        if (this.isAlive()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.playSound(this.type.getPrimeSound(this).orElse(SoundEvents.CREEPER_PRIMED), 1.0f, 0.5f);
                this.gameEvent((Holder)GameEvent.PRIME_FUSE);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explode();
            }
        }
        super.tick();
    }

    public void explode() {
        if (!this.level().isClientSide) {
            Level.ExplosionInteraction interaction = PlatformUtils.getInteractionForCreeper(this);
            this.dead = true;
            Explosion explosion = this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 3.0f * (this.isPowered() ? 2.0f : 1.0f), interaction);
            this.type.getExplosionSound(this).ifPresent(s -> this.level().playSound(null, (Entity)this, s, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f));
            this.discard();
            if (!this.type.inflictingPotions().isEmpty()) {
                explosion.getHitPlayers().keySet().forEach(player -> {
                    List<MobEffectInstance> inflictingPotions = this.type.inflictingPotions().stream().map(MobEffectInstance::new).toList();
                    inflictingPotions.forEach(arg_0 -> ((Player)player).addEffect(arg_0));
                });
            }
            if (!this.type.replacer().isEmpty()) {
                Set<Map.Entry<Predicate<BlockState>, Function<RandomSource, BlockState>>> entries = this.type.replacer().entrySet();
                explosion.getToBlow().stream().map(BlockPos::below).forEach(pos -> {
                    BlockState state = this.level().getBlockState(pos);
                    for (Map.Entry entry : entries) {
                        BlockState newState;
                        if (!((Predicate)entry.getKey()).test(state) || (newState = (BlockState)((Function)entry.getValue()).apply(this.random)) == null) continue;
                        this.level().setBlock(pos, newState, 3);
                        break;
                    }
                });
            }
            Stream<MobEffectInstance> potions = Stream.concat(this.getActiveEffects().stream().map(MobEffectInstance::new), this.type.potionsWhenDead().stream().map(MobEffectInstance::new));
            this.summonCloudWithEffects(potions.toList());
        }
    }

    private void summonCloudWithEffects(Collection<MobEffectInstance> effects) {
        if (!effects.isEmpty()) {
            AreaEffectCloud cloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            cloud.setRadius(2.5f);
            cloud.setRadiusOnUse(-0.5f);
            cloud.setWaitTime(10);
            cloud.setDuration(cloud.getDuration() / 2);
            cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
            effects.forEach(arg_0 -> ((AreaEffectCloud)cloud).addEffect(arg_0));
            this.level().addFreshEntity((Entity)cloud);
        }
    }

    public float getSwelling(float f) {
        return Mth.lerp((float)f, (float)this.oldSwell, (float)this.swell) / ((float)this.maxSwell - 2.0f);
    }

    public boolean canSwell() {
        return this.isExplodingCreeper();
    }

    public boolean isExplodingCreeper() {
        return this.type.melee() == 0;
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        EquipmentSlot slot;
        ItemStack stack = player.getItemInHand(hand);
        EquipmentSlot equipmentSlot = slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        if (this.isExplodingCreeper() && PlatformUtils.isFlintAndSteel(stack)) {
            this.level().playSound(player, this.blockPosition(), SoundEvents.FLINTANDSTEEL_USE, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!this.level().isClientSide()) {
                this.ignite();
                stack.hurtAndBreak(1, (LivingEntity)player, slot);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.readyForShearing() && PlatformUtils.isShears(stack)) {
            this.shear(SoundSource.AMBIENT);
            this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
            stack.hurtAndBreak(1, (LivingEntity)player, slot);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean shouldRevenge() {
        return true;
    }

    public double getAttributeValue(Holder<Attribute> attribute) {
        return super.getAttributeValue(attribute) * (double)(attribute.equals((Object)Attributes.ATTACK_DAMAGE) && this.isPowered() ? 2 : 1);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        if (this.canSwell()) {
            return true;
        }
        DamageSource damageSource = this.level().damageSources().mobAttack((LivingEntity)this);
        float damage = (float)this.getAttributeValue((Holder<Attribute>)Attributes.ATTACK_DAMAGE);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)damage);
        }
        if (entity.hurt(damageSource, damage)) {
            Level level2;
            float knockback = this.getKnockback(entity, damageSource);
            if ((double)knockback > 0.0 && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.knockback((double)(knockback * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damageSource);
            }
            this.setLastHurtMob(entity);
            return true;
        }
        return false;
    }

    public float getSpeed() {
        return super.getSpeed() * (this.isPowered() ? 1.5f : 1.0f);
    }

    public boolean isDamageSourceBlocked(@NotNull DamageSource source) {
        return super.isDamageSourceBlocked(source) || this.type.immunities().contains(source);
    }

    @NotNull
    protected AABB getAttackBoundingBox() {
        AttributeInstance reachAttribute = this.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        double reach = reachAttribute != null ? reachAttribute.getValue() : 0.0;
        return super.getAttackBoundingBox().inflate(reach, 0.0, reach);
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return this.type.getHurtSound(this).orElseGet(() -> super.getHurtSound(source));
    }

    protected SoundEvent getDeathSound() {
        return this.type.getDeathSound(this).orElseGet(() -> super.getDeathSound());
    }

    @NotNull
    protected SoundEvent getSwimSound() {
        return this.type.getSwimSound(this).orElseGet(() -> super.getSwimSound());
    }

    protected <E extends GeoAnimatable> PlayState animate(AnimationState<E> event) {
        AnimationProcessor.QueuedAnimation animation = event.getController().getCurrentAnimation();
        if (this.isAttacking()) {
            event.getController().setAnimation(AnimationConstants.ATTACK);
        } else {
            if (animation != null && animation.animation().name().equals("animation.creeper.attack") && event.getController().getAnimationState().equals((Object)AnimationController.State.RUNNING)) {
                return PlayState.CONTINUE;
            }
            if (event.isMoving()) {
                event.getController().setAnimation(AnimationConstants.WALK);
            } else {
                event.getController().setAnimation(AnimationConstants.IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 3, this::animate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void shear(SoundSource soundSource) {
        this.level().playSound(null, (Entity)this, SoundEvents.SNOW_GOLEM_SHEAR, soundSource, 1.0f, 1.0f);
        if (!this.level().isClientSide()) {
            this.spawnAtLocation(this.type.shearDrop().get(), 1.7f);
        }
    }

    public boolean readyForShearing() {
        return !this.isSheared() && this.type.isShearable();
    }
}

