/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.ReplacedSnowGolemRenderer;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;

public class PumpkinLayer
extends GeoRenderLayer<ReplacedSnowGolem> {
    private final ReplacedSnowGolemRenderer renderer;

    public PumpkinLayer(ReplacedSnowGolemRenderer entityRendererIn) {
        super((GeoRenderer)entityRendererIn);
        this.renderer = entityRendererIn;
    }

    public void renderForBone(PoseStack stack, ReplacedSnowGolem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        SnowGolem golem = (SnowGolem)this.renderer.getCurrentEntity();
        if (golem.hasPumpkin() && bone.getName().equals("head")) {
            boolean flag;
            Minecraft minecraft = Minecraft.getInstance();
            boolean bl = flag = minecraft.shouldEntityAppearGlowing((Entity)golem) && golem.isInvisible();
            if (!golem.isInvisible() || flag) {
                stack.pushPose();
                stack.translate(0.0, 1.6, 0.0);
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                stack.scale(0.6f, -0.6f, -0.6f);
                if (flag) {
                    BlockState blockstate = Blocks.CARVED_PUMPKIN.defaultBlockState();
                    BlockRenderDispatcher blockrenderdispatcher = minecraft.getBlockRenderer();
                    BakedModel bakedmodel = blockrenderdispatcher.getBlockModel(blockstate);
                    int i = LivingEntityRenderer.getOverlayCoords((LivingEntity)golem, (float)0.0f);
                    stack.translate(-0.5, -0.5, -0.5);
                    blockrenderdispatcher.getModelRenderer().renderModel(stack.last(), bufferSource.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), blockstate, bakedmodel, 0.0f, 0.0f, 0.0f, packedLight, i);
                } else {
                    minecraft.getItemRenderer().renderStatic((LivingEntity)golem, new ItemStack((ItemLike)Blocks.CARVED_PUMPKIN), ItemDisplayContext.HEAD, false, stack, bufferSource, golem.level(), packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)golem, (float)0.0f), golem.getId());
                }
                stack.popPose();
            }
        }
    }
}

