/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.SnowGolem;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.ReplacedSnowGolemRenderer;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;

public class RandomFaceLayer
extends GeoRenderLayer<ReplacedSnowGolem> {
    private static final int SIZE = 12;
    private static final ResourceLocation[] TEXTURES = (ResourceLocation[])Util.make(() -> {
        ResourceLocation[] textures = new ResourceLocation[12];
        for (int i = 0; i < 12; ++i) {
            textures[i] = WinterOverhaul.id("textures/entity/faces/snow_golem_face_" + (i + 1) + ".png");
        }
        return textures;
    });
    private final ReplacedSnowGolemRenderer renderer;

    public RandomFaceLayer(ReplacedSnowGolemRenderer entityRendererIn) {
        super((GeoRenderer)entityRendererIn);
        this.renderer = entityRendererIn;
    }

    public void render(PoseStack poseStack, ReplacedSnowGolem animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        SnowGolem entity = (SnowGolem)this.renderer.getCurrentEntity();
        if (entity.isInvisible()) {
            return;
        }
        if (entity.hasPumpkin()) {
            return;
        }
        RenderType renderType1 = RenderType.entityTranslucent((ResourceLocation)this.getRandomTexture(entity.getUUID()));
        VertexConsumer consumer = bufferSource.getBuffer(renderType1);
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType1, consumer, partialTick, packedLight, packedOverlay, -1);
    }

    private ResourceLocation getRandomTexture(UUID uuid) {
        return TEXTURES[(int)(Math.abs(uuid.getLeastSignificantBits() ^ (uuid.getMostSignificantBits() | 0xFF00FFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) % 12L)];
    }
}

