/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.djefrey.colorwheel.engine.ClrwlBlendModeOverride;
import dev.engine_room.flywheel.api.material.DepthTest;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.material.Transparency;
import dev.engine_room.flywheel.api.material.WriteMask;
import dev.engine_room.flywheel.backend.Samplers;
import java.util.List;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.BufferBlendInformation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.jetbrains.annotations.Nullable;

public final class ClrwlMaterialRenderState {
    public static void setup(Material material, @Nullable ClrwlBlendModeOverride blendOverride, List<BufferBlendInformation> bufferBlendOverrides) {
        ClrwlMaterialRenderState.setupTexture(material);
        ClrwlMaterialRenderState.setupBackfaceCulling(material.backfaceCulling());
        ClrwlMaterialRenderState.setupPolygonOffset(material.polygonOffset());
        ClrwlMaterialRenderState.setupDepthTest(material.depthTest());
        ClrwlMaterialRenderState.setupTransparency(material.transparency(), blendOverride, bufferBlendOverrides);
        ClrwlMaterialRenderState.setupWriteMask(material.writeMask());
    }

    public static void setupOit(Material material) {
        ClrwlMaterialRenderState.setupTexture(material);
        ClrwlMaterialRenderState.setupBackfaceCulling(material.backfaceCulling());
        ClrwlMaterialRenderState.setupPolygonOffset(material.polygonOffset());
        ClrwlMaterialRenderState.setupDepthTest(material.depthTest());
        WriteMask mask = material.writeMask();
        boolean writeColor = mask.color();
        RenderSystem.colorMask((boolean)writeColor, (boolean)writeColor, (boolean)writeColor, (boolean)writeColor);
    }

    private static void setupTexture(Material material) {
        Samplers.DIFFUSE.makeActive();
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(material.texture());
        texture.setFilter(material.blur(), material.mipmap());
        int textureId = texture.getId();
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        RenderSystem.bindTexture((int)textureId);
    }

    private static void setupBackfaceCulling(boolean backfaceCulling) {
        if (backfaceCulling) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
    }

    private static void setupPolygonOffset(boolean polygonOffset) {
        if (polygonOffset) {
            RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
            RenderSystem.enablePolygonOffset();
        } else {
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
        }
    }

    private static void setupDepthTest(DepthTest depthTest) {
        switch (depthTest) {
            case OFF: {
                RenderSystem.disableDepthTest();
                break;
            }
            case NEVER: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)512);
                break;
            }
            case LESS: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)513);
                break;
            }
            case EQUAL: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)514);
                break;
            }
            case LEQUAL: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
                break;
            }
            case GREATER: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)516);
                break;
            }
            case NOTEQUAL: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)517);
                break;
            }
            case GEQUAL: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)518);
                break;
            }
            case ALWAYS: {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)519);
            }
        }
    }

    private static void setupTransparency(Transparency transparency, @Nullable ClrwlBlendModeOverride blendOverride, List<BufferBlendInformation> bufferBlendOverrides) {
        if (blendOverride == null) {
            switch (transparency) {
                case OPAQUE: {
                    RenderSystem.disableBlend();
                    break;
                }
                case ADDITIVE: {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    break;
                }
                case LIGHTNING: {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    break;
                }
                case GLINT: {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    break;
                }
                case CRUMBLING: {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    break;
                }
                case TRANSLUCENT: {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }
            }
        } else if (blendOverride.blendMode() == null) {
            RenderSystem.disableBlend();
        } else {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)blendOverride.blendMode().srcRgb(), (int)blendOverride.blendMode().dstRgb(), (int)blendOverride.blendMode().srcAlpha(), (int)blendOverride.blendMode().dstAlpha());
        }
        for (BufferBlendInformation entry : bufferBlendOverrides) {
            if (entry.blendMode() == null) {
                IrisRenderSystem.disableBufferBlend((int)entry.index());
                continue;
            }
            IrisRenderSystem.enableBufferBlend((int)entry.index());
            IrisRenderSystem.blendFuncSeparatei((int)entry.index(), (int)entry.blendMode().srcRgb(), (int)entry.blendMode().dstRgb(), (int)entry.blendMode().srcAlpha(), (int)entry.blendMode().dstAlpha());
        }
    }

    private static void setupWriteMask(WriteMask mask) {
        RenderSystem.depthMask((boolean)mask.depth());
        boolean writeColor = mask.color();
        RenderSystem.colorMask((boolean)writeColor, (boolean)writeColor, (boolean)writeColor, (boolean)writeColor);
    }

    public static void reset() {
        ClrwlMaterialRenderState.resetTexture();
        ClrwlMaterialRenderState.resetBackfaceCulling();
        ClrwlMaterialRenderState.resetPolygonOffset();
        ClrwlMaterialRenderState.resetDepthTest();
        ClrwlMaterialRenderState.resetTransparency();
        ClrwlMaterialRenderState.resetWriteMask();
    }

    private static void resetTexture() {
        Samplers.DIFFUSE.makeActive();
        RenderSystem.setShaderTexture((int)0, (int)0);
    }

    private static void resetBackfaceCulling() {
        RenderSystem.enableCull();
    }

    private static void resetPolygonOffset() {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    }

    private static void resetDepthTest() {
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
    }

    private static void resetTransparency() {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private static void resetWriteMask() {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

