/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock;

import com.railwayteam.railways.content.buffer.DyeableBlockEntity;
import com.railwayteam.railways.content.buffer.IMaterialAdaptingBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HeadstockBlockEntity
extends DyeableBlockEntity
implements IMaterialAdaptingBuffer {
    protected BlockState material = Blocks.SPRUCE_PLANKS.defaultBlockState();

    public HeadstockBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @NotNull
    public BlockState getMaterial() {
        return this.material;
    }

    public InteractionResult applyMaterialIfValid(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState material = blockItem.getBlock().defaultBlockState();
        if (material == this.material) {
            return InteractionResult.PASS;
        }
        if (!material.is(BlockTags.PLANKS)) {
            return InteractionResult.PASS;
        }
        if (this.level.isClientSide() && !this.isVirtual()) {
            return InteractionResult.SUCCESS;
        }
        this.material = material;
        this.notifyUpdate();
        this.level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)material));
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.read(compound, lookupProvider, clientPacket);
        BlockState prevMaterial = this.material;
        if (!compound.contains("Material")) {
            return;
        }
        this.material = NbtUtils.readBlockState((HolderGetter)this.blockHolderGetter(), (CompoundTag)compound.getCompound("Material"));
        if (this.material.isAir()) {
            this.material = Blocks.SPRUCE_PLANKS.defaultBlockState();
        }
        if (clientPacket && prevMaterial != this.material) {
            this.redraw();
        }
    }

    @Override
    public void write(CompoundTag compound, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.write(compound, lookupProvider, clientPacket);
        compound.put("Material", (Tag)NbtUtils.writeBlockState((BlockState)this.material));
    }
}

