/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.neoforge;

import com.railwayteam.railways.content.buffer.BufferModelUtils;
import com.railwayteam.railways.content.buffer.IDyedBuffer;
import com.railwayteam.railways.content.buffer.IMaterialAdaptingBuffer;
import com.railwayteam.railways.content.buffer.TrackBufferBlock;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class BufferModel
implements BakedModel {
    private final BakedModel wrapped;
    private static final ModelProperty<@Nullable BlockState> MATERIAL = new ModelProperty();
    private static final ModelProperty<@Nullable DyeColor> COLOR = new ModelProperty();
    private static final Matrix3d diagonalTransform = new Matrix3d().asYRotation((float)Math.toRadians(-45.0));

    public BufferModel(BakedModel wrapped) {
        this.wrapped = wrapped;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        Object be;
        BlockState material = null;
        DyeColor color = null;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IDyedBuffer) {
            be = (IDyedBuffer)blockEntity;
            color = be.getColor();
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof IMaterialAdaptingBuffer) {
            be = (IMaterialAdaptingBuffer)blockEntity;
            material = be.getMaterial();
        }
        return modelData.derive().with(MATERIAL, material).with(COLOR, (Object)color).build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        BlockState material = (BlockState)data.get(MATERIAL);
        DyeColor color = (DyeColor)data.get(COLOR);
        if (material != null || color != null) {
            return BakedModelHelper.swapSprites(this.transformQuads(this.wrapped.getQuads(state, side, rand), state), BufferModelUtils.combineSwappers(BufferModelUtils.getSwapper(material), BufferModelUtils.getSwapper(color)));
        }
        return this.transformQuads(this.wrapped.getQuads(state, side, rand), state);
    }

    private BakedQuad applyDiagonalTransform(BakedQuad quad) {
        BakedQuad newQuad = BakedQuadHelper.clone((BakedQuad)quad);
        int[] vertexData = newQuad.getVertices();
        for (int vertex = 0; vertex < 4; ++vertex) {
            Vec3 vertexPos = BakedQuadHelper.getXYZ((int[])vertexData, (int)vertex);
            vertexPos = vertexPos.subtract(0.5, 0.5, 0.5);
            vertexPos = diagonalTransform.transform(vertexPos);
            vertexPos = vertexPos.add(0.5, 0.5, 0.5);
            BakedQuadHelper.setXYZ((int[])vertexData, (int)vertex, (Vec3)vertexPos);
        }
        return newQuad;
    }

    private List<BakedQuad> transformQuads(List<BakedQuad> quads, @Nullable BlockState state) {
        if (state == null) {
            return quads;
        }
        boolean isDiagonal = false;
        if (state.getBlock() instanceof TrackBufferBlock) {
            isDiagonal = (Boolean)state.getValue((Property)TrackBufferBlock.DIAGONAL);
        }
        if (!isDiagonal) {
            return quads;
        }
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : quads) {
            transformedQuads.add(this.applyDiagonalTransform(quad));
        }
        return transformedQuads;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random) {
        return Collections.emptyList();
    }

    public List<BakedModel> getRenderPasses(@NotNull ItemStack stack, boolean fabulous) {
        UnaryOperator<TextureAtlasSprite> materialSwapper = null;
        UnaryOperator<TextureAtlasSprite> colorSwapper = null;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag != null && tag.contains("BlockEntityTag", 10)) {
            CompoundTag blockEntityTag = tag.getCompound("BlockEntityTag");
            if (blockEntityTag.contains("Material", 10)) {
                materialSwapper = BufferModelUtils.getSwapper(NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)blockEntityTag.getCompound("Material")));
            }
            if (blockEntityTag.contains("Color", 3)) {
                colorSwapper = BufferModelUtils.getSwapper(DyeColor.byId((int)blockEntityTag.getInt("Color")));
            }
        }
        final UnaryOperator<TextureAtlasSprite> finalMaterialSwapper = materialSwapper;
        final UnaryOperator<TextureAtlasSprite> finalColorSwapper = colorSwapper;
        return List.of(new BufferModel(this.wrapped){

            @Override
            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random) {
                if (finalMaterialSwapper != null || finalColorSwapper != null) {
                    return BakedModelHelper.swapSprites((List)BufferModel.this.wrapped.getQuads(state, direction, random), BufferModelUtils.combineSwappers(finalMaterialSwapper, finalColorSwapper));
                }
                return BufferModel.this.wrapped.getQuads(state, direction, random);
            }
        });
    }

    public boolean useAmbientOcclusion() {
        return this.wrapped.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.wrapped.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.wrapped.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.wrapped.getParticleIcon();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapped.getParticleIcon(data);
    }

    public ItemOverrides getOverrides() {
        return this.wrapped.getOverrides();
    }

    public ItemTransforms getTransforms() {
        return this.wrapped.getTransforms();
    }
}

