/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.railwayteam.railways.content.fuel.LiquidFuelTrainHandler;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FuelTankBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    protected boolean forceFluidLevelUpdate = true;
    protected FuelFluidHandler tankInventory = this.createInventory();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    protected boolean window = true;
    protected int luminosity;
    protected int width = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;

    public FuelTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.refreshCapability();
    }

    protected FuelFluidHandler createInventory() {
        return new FuelFluidHandler(FuelTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    FuelTankBlockEntity tankAt = (FuelTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.getType(), (BlockGetter)this.level, (BlockPos)pos);
                    if (tankAt == null) continue;
                    this.level.updateNeighbourForOutputSignal(pos, tankAt.getBlockState().getBlock());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.level.isClientSide) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public FuelTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof FuelTankBlockEntity) {
            return (FuelTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * FuelTankBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        BlockState state = this.getBlockState();
        if (FuelTankBlock.isTank(state)) {
            state = (BlockState)state.setValue((Property)FuelTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue((Property)FuelTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue(FuelTankBlock.SHAPE, (Comparable)((Object)(this.window ? FuelTankBlock.Shape.WINDOW : FuelTankBlock.Shape.PLAIN)));
            this.getLevel().setBlock(this.worldPosition, state, 22);
        }
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void toggleWindows() {
        FuelTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.setWindows(!be.window);
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    BlockState blockState = this.level.getBlockState(pos);
                    if (!FuelTankBlock.isTank(blockState)) continue;
                    FuelTankBlock.Shape shape = FuelTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = FuelTankBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            FuelTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FuelTankBlock.Shape.WINDOW_NW : FuelTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FuelTankBlock.Shape.WINDOW_NE : FuelTankBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                            shape = FuelTankBlock.Shape.WINDOW;
                        }
                    }
                    this.level.setBlock(pos, (BlockState)blockState.setValue(FuelTankBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.level.getChunkSource().getLightEngine().checkBlock(pos);
                }
            }
        }
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    private void refreshCapability() {
        if (this.level != null) {
            this.invalidateAllPartsCapabilities();
        }
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().expandTowards((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        FuelTankBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getFluidHandler(null));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider provider, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, provider, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.luminosity = compound.getInt("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"LastKnownPos").orElse(null);
        }
        if (compound.contains("Controller")) {
            this.controller = NbtUtils.readBlockPos((CompoundTag)compound, (String)"Controller").orElse(null);
        }
        if (this.isController()) {
            this.window = compound.getBoolean("Window");
            this.width = compound.getInt("Size");
            this.height = compound.getInt("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * FuelTankBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(provider, compound.getCompound("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (compound.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FuelTankBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.contains("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (this.luminosity != prevLum && this.hasLevel()) {
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
        if (compound.contains("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public void write(CompoundTag compound, HolderLookup.Provider provider, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.putBoolean("Window", this.window);
            compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(provider, new CompoundTag()));
            compound.putInt("Size", this.width);
            compound.putInt("Height", this.height);
        }
        compound.putInt("Luminosity", this.luminosity);
        super.write(compound, provider, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.putBoolean("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.putBoolean("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.STEAM_ENGINE_MAXED, AllAdvancements.PIPE_ORGAN});
    }

    public FluidTank getTankInventory() {
        return this.tankInventory;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.getBlockState();
        if (FuelTankBlock.isTank(state)) {
            state = (BlockState)state.setValue((Property)FuelTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().getY() == this.getBlockPos().getY()));
            state = (BlockState)state.setValue((Property)FuelTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().getY() + this.height - 1 == this.getBlockPos().getY()));
            this.level.setBlock(this.getBlockPos(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.setChanged();
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return FuelTankBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return FuelTankBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }

    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        return this.handlerForCapability();
    }

    private void invalidateAllPartsCapabilities() {
        if (this.level == null) {
            return;
        }
        if (this.isController()) {
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                        BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                        this.level.invalidateCapabilities(pos);
                    }
                }
            }
        } else {
            this.level.invalidateCapabilities(this.worldPosition);
        }
    }

    public static class FuelFluidHandler
    extends SmartFluidTank {
        public FuelFluidHandler(int capacity, Consumer<FluidStack> updateCallback) {
            super(capacity, updateCallback);
        }

        public boolean isFluidValid(FluidStack stack) {
            return LiquidFuelTrainHandler.isFuelForTanks(stack.getFluid());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(resource)) {
                return 0;
            }
            return super.fill(resource, action);
        }
    }
}

