/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block;

import com.railwayteam.railways.content.smokestack.block.SmokeStackBlock;
import com.railwayteam.railways.util.ShapeWrapper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AxisSmokeStackBlock
extends SmokeStackBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public AxisSmokeStackBlock(BlockBehaviour.Properties properties, SmokeStackBlock.SmokeStackType type, ShapeWrapper shape, boolean createsStationarySmoke, String variant) {
        super(properties, type, shape, createsStationarySmoke, variant);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(AXIS, (Comparable)rot.rotate(state.getValue(AXIS) == Direction.Axis.X ? Direction.WEST : Direction.NORTH).getAxis());
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape.get((Direction.Axis)pState.getValue(AXIS));
    }

    @Override
    protected BlockState makeDefaultState() {
        return (BlockState)super.makeDefaultState().setValue(AXIS, (Comparable)Direction.Axis.X);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = super.getStateForPlacement(context);
        if (blockstate == null) {
            return null;
        }
        Direction direction = context.getHorizontalDirection();
        if (direction.getAxis().isHorizontal()) {
            blockstate = (BlockState)blockstate.setValue(AXIS, (Comparable)direction.getAxis());
        }
        return blockstate;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.setValue(AXIS, (Comparable)(originalState.getValue(AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }
}

