/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block.be;

import com.railwayteam.railways.content.smokestack.block.SmokeStackBlock;
import com.railwayteam.railways.util.ColorUtils;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SmokeStackBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    @Nullable
    protected DyeColor color = null;
    protected boolean isSoul = false;

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(@Nullable DyeColor color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.isSoul = false;
        this.notifyUpdate();
    }

    public void setSoul(boolean isSoul) {
        if (this.isSoul == isSoul) {
            return;
        }
        this.color = null;
        this.isSoul = isSoul;
        this.notifyUpdate();
    }

    public boolean isSoul() {
        return this.color == null && this.isSoul;
    }

    public SmokeStackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void read(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.read(tag, lookupProvider, clientPacket);
        if (tag.contains("color", 3)) {
            int colorOrdinal = tag.getInt("color");
            this.color = DyeColor.byId((int)colorOrdinal);
        } else {
            this.color = null;
        }
        this.isSoul = tag.getBoolean("isSoul");
    }

    protected void write(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.write(tag, lookupProvider, clientPacket);
        if (this.color != null) {
            tag.putInt("color", this.color.getId());
        }
        tag.putBoolean("isSoul", this.isSoul());
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.color != null) {
            Lang.builder((String)"railways").translate("smokestack.goggle.tooltip.color", new Object[]{ColorUtils.coloredName(this.color.getName())}).forGoggles(tooltip);
        }
        if (this.isSoul || this.color == null) {
            Lang.builder((String)"railways").translate("smokestack.goggle.tooltip", new Object[]{this.isSoul ? "Soul" : ColorUtils.coloredName(DyeColor.BLACK.toString())}).forGoggles(tooltip);
        }
        return true;
    }

    public ItemStack getIcon(boolean isPlayerSneaking) {
        if (this.color != null) {
            return ColorUtils.getDyeColorDyeItem(this.color).getDefaultInstance();
        }
        return this.isSoul ? Items.SOUL_SOIL.getDefaultInstance() : Items.BLACK_DYE.getDefaultInstance();
    }

    public void tick() {
        super.tick();
        if (this.level != null && this.level.isClientSide && this.level.getRandom().nextFloat() < 0.11f) {
            ((SmokeStackBlock)this.getBlockState().getBlock()).blockEntityAnimateTick(this.getBlockState(), this.level, this.getBlockPos(), this.level.getRandom());
        }
    }
}

