/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.puffs;

import com.railwayteam.railways.content.smokestack.particles.CustomAnimatedTextureSheetParticle;
import com.railwayteam.railways.content.smokestack.particles.puffs.PuffSmokeParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PuffSmokeParticle
extends CustomAnimatedTextureSheetParticle {
    public static final int DOUBLE_SPEED_SENTINEL = 42;
    protected final boolean stationarySource;
    protected final RandomSource random;

    protected PuffSmokeParticle(ClientLevel level, double x, double y, double z, RandomSource random, boolean stationarySource, double ySpeed) {
        super(level, x, y, z, 0.0, ySpeed, 0.0);
        if (Mth.equal((double)42.0, (double)ySpeed)) {
            this.yd *= 1.5;
        }
        this.quadSize = 1.0f;
        this.friction = 0.99f;
        this.random = random;
        this.stationarySource = stationarySource;
        this.setLifetime(random.nextIntBetweenInclusive(65, 105) + (stationarySource ? 60 : 0));
    }

    @Override
    protected double getAnimationProgress() {
        int age = Math.min(this.age, this.lifetime - 1);
        double lifeFactor = (double)age / (double)this.lifetime;
        double f = 0.1;
        lifeFactor = this.stationarySource ? lifeFactor * lifeFactor : Math.max(0.0, (lifeFactor - f) * (lifeFactor - f) - f * f);
        return lifeFactor;
    }

    public void tick() {
        float diffusionScale;
        super.tick();
        float f = diffusionScale = this.stationarySource ? 800.0f : 500.0f;
        if (this.age > 350) {
            diffusionScale = 5000.0f;
        } else if (this.age > 300) {
            diffusionScale = Mth.lerp((float)((float)(this.age - 300) / 50.0f), (float)(this.stationarySource ? 800.0f : 500.0f), (float)5000.0f);
        }
        this.xd += (double)(this.random.nextFloat() / diffusionScale * (float)(this.random.nextBoolean() ? 1 : -1));
        this.zd += (double)(this.random.nextFloat() / diffusionScale * (float)(this.random.nextBoolean() ? 1 : -1));
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory<T extends PuffSmokeParticleData<T>>
    implements ParticleProvider<T> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull T type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PuffSmokeParticle particle = new PuffSmokeParticle(level, x, y, z, level.getRandom(), ((PuffSmokeParticleData)type).stationary, ySpeed);
            int textureCount = 19;
            int idx = 0;
            if (Mth.equal((float)((PuffSmokeParticleData)type).red, (float)-1.0f) && Mth.equal((float)((PuffSmokeParticleData)type).green, (float)-1.0f) && Mth.equal((float)((PuffSmokeParticleData)type).blue, (float)-1.0f)) {
                idx = 1;
            } else if (Mth.equal((float)((PuffSmokeParticleData)type).red, (float)-2.0f) && Mth.equal((float)((PuffSmokeParticleData)type).green, (float)-2.0f) && Mth.equal((float)((PuffSmokeParticleData)type).blue, (float)-2.0f)) {
                idx = 2;
            } else if (Mth.equal((float)((PuffSmokeParticleData)type).red, (float)((PuffSmokeParticleData)type).green) && Mth.equal((float)((PuffSmokeParticleData)type).green, (float)((PuffSmokeParticleData)type).blue) && ((PuffSmokeParticleData)type).red < -2.0f && ((PuffSmokeParticleData)type).red >= -18.0f) {
                idx = (int)Math.abs(((PuffSmokeParticleData)type).red);
            }
            particle.setSprite(this.spriteSet.get(idx, textureCount - 1));
            particle.age = level.getRandom().nextInt(5);
            if (idx == 0) {
                particle.rCol = ((PuffSmokeParticleData)type).red;
                particle.gCol = ((PuffSmokeParticleData)type).green;
                particle.bCol = ((PuffSmokeParticleData)type).blue;
            }
            particle.quadSize = ((PuffSmokeParticleData)type).getQuadSize();
            return particle;
        }
    }
}

