/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.railwayteam.railways.mixin_interfaces.ILimited;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.StationLimitPacket;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.AbstractStationScreen;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationScreen;
import com.simibubi.create.content.trains.station.TrainEditPacket;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StationScreen.class}, remap=false)
public abstract class MixinStationScreen
extends AbstractStationScreen {
    @Shadow
    private EditBox trainNameBox;
    @Unique
    private Checkbox railways$limitCheckbox;
    @Unique
    private List<ResourceLocation> railways$iconTypes;
    @Unique
    private ScrollInput railways$iconTypeScroll;

    private MixinStationScreen(StationBlockEntity te, GlobalStation station) {
        super(te, station);
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/StationScreen;tickTrainDisplay()V")}, remap=true)
    private void railways$initCheckbox(CallbackInfo ci) {
        int x = this.guiLeft;
        int y = this.guiTop;
        boolean limitEnabled = this.station != null && ((ILimited)this.station).isLimitEnabled();
        this.railways$limitCheckbox = Checkbox.builder((Component)Component.translatable((String)"railways.station.train_limit"), (Font)Minecraft.getInstance().font).pos(x + this.background.getWidth() - 98, y + this.background.getHeight() - 26).selected(limitEnabled).onValueChange((checkbox, selected) -> CRPackets.PACKETS.send(new StationLimitPacket(this.blockEntity.getBlockPos(), selected))).build();
        this.addRenderableWidget((GuiEventListener)this.railways$limitCheckbox);
        this.railways$iconTypes = new ArrayList(TrainIconType.REGISTRY.keySet());
        this.railways$iconTypeScroll = new ScrollInput(x + 4, y + 17, 160, 14).withRange(0, this.railways$iconTypes.size()).inverted().titled(Component.literal((String)"Train Icon").withStyle(s -> s.withColor(0xFFFFFF))).calling(idx -> {
            TrainIconType iconType;
            Train imminentTrain = this.getImminent();
            if (imminentTrain == null) {
                return;
            }
            ResourceLocation iconId = this.railways$iconTypes.get((int)idx);
            imminentTrain.icon = iconType = TrainIconType.byId((ResourceLocation)iconId);
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new TrainEditPacket.Serverbound(imminentTrain.id, imminentTrain.name.getString(), iconId, imminentTrain.mapColorIndex));
        });
        this.railways$iconTypeScroll.active = false;
    }

    @Inject(method={"tickTrainDisplay"}, at={@At(value="HEAD")})
    private void railways$tickIconScroll(CallbackInfo ci) {
        if (this.railways$iconTypeScroll == null) {
            return;
        }
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            Train imminentTrain;
            if (this.railways$iconTypeScroll.active) {
                this.railways$iconTypeScroll.active = false;
                this.removeWidget((GuiEventListener)this.railways$iconTypeScroll);
            }
            if ((imminentTrain = this.getImminent()) != null) {
                this.railways$iconTypeScroll.active = true;
                int idx = this.railways$iconTypes.indexOf(imminentTrain.icon.getId());
                if (idx >= 0) {
                    this.railways$iconTypeScroll.setState(idx);
                }
                this.addRenderableWidget((GuiEventListener)this.railways$iconTypeScroll);
            }
        }
    }
}

