/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.recipe.RailwaysRecipeProvider;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.content.conductor.remote_lens.RemoteLensItem;
import com.railwayteam.railways.content.minecarts.MinecartJukebox;
import com.railwayteam.railways.content.minecarts.MinecartWorkbench;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;

public class CRItems {
    private static final CreateRegistrate REGISTRATE = Railways.registrate();
    public static final TagKey<Item> CONDUCTOR_CAPS = CRTags.AllItemTags.CONDUCTOR_CAPS.tag;
    public static final ItemEntry<? extends Item> ITEM_BENCHCART = CRItems.makeMinecart("benchcart", () -> MinecartWorkbench.getWorkbenchType()).recipe((ctx, prov) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)ctx.get())).requires((ItemLike)Items.MINECART).requires(CommonTags.WORKBENCH.tag).unlockedBy("hasitem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MINECART})).save((RecipeOutput)prov)).lang("Minecart with Workbench").register();
    public static final ItemEntry<? extends Item> ITEM_JUKEBOXCART = CRItems.makeMinecart("jukeboxcart", () -> MinecartJukebox.getJukeboxType()).recipe((ctx, prov) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)ctx.get())).requires((ItemLike)Items.MINECART).requires((ItemLike)Items.JUKEBOX).unlockedBy("hasitem", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MINECART})).save((RecipeOutput)prov)).lang("Minecart with Jukebox").register();
    public static final ItemEntry<? extends RemoteLensItem> REMOTE_LENS = REGISTRATE.item("remote_lens", RemoteLensItem::new).lang("Remote Lens").register();
    public static final EnumMap<DyeColor, ItemEntry<ConductorCapItem>> ITEM_CONDUCTOR_CAP = new EnumMap(DyeColor.class);
    public static final EnumMap<DyeColor, ItemEntry<SequencedAssemblyItem>> ITEM_INCOMPLETE_CONDUCTOR_CAP = new EnumMap(DyeColor.class);
    public static final Map<TrackMaterial, ItemEntry<SequencedAssemblyItem>> ITEM_INCOMPLETE_TRACK = new HashMap<TrackMaterial, ItemEntry<SequencedAssemblyItem>>();

    public static TagKey<Item> makeItemTag(String mod, String path) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)mod, (String)path));
    }

    private static ItemBuilder<? extends Item, ?> makeMinecart(String name, Supplier<AbstractMinecart.Type> typeSupplier) {
        return REGISTRATE.item(name, props -> new MinecartItem((AbstractMinecart.Type)typeSupplier.get(), props)).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(name, prov.mcLoc("item/minecart"))).texture("layer0", prov.modLoc("item/" + name)));
    }

    public static Item woolByColor(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Items.WHITE_WOOL;
            case DyeColor.ORANGE -> Items.ORANGE_WOOL;
            case DyeColor.MAGENTA -> Items.MAGENTA_WOOL;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_WOOL;
            case DyeColor.YELLOW -> Items.YELLOW_WOOL;
            case DyeColor.LIME -> Items.LIME_WOOL;
            case DyeColor.PINK -> Items.PINK_WOOL;
            case DyeColor.GRAY -> Items.GRAY_WOOL;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_WOOL;
            case DyeColor.CYAN -> Items.CYAN_WOOL;
            case DyeColor.PURPLE -> Items.PURPLE_WOOL;
            case DyeColor.BLUE -> Items.BLUE_WOOL;
            case DyeColor.BROWN -> Items.BROWN_WOOL;
            case DyeColor.GREEN -> Items.GREEN_WOOL;
            case DyeColor.RED -> Items.RED_WOOL;
            case DyeColor.BLACK -> Items.BLACK_WOOL;
        };
    }

    private static ItemEntry<SequencedAssemblyItem> sequencedIngredient(String name) {
        return REGISTRATE.item(name, SequencedAssemblyItem::new).register();
    }

    public static void register() {
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            String colorName = TextUtils.titleCaseConversion(color.getName().replace("_", " "));
            String colorReg = color.getName().toLowerCase(Locale.ROOT);
            ITEM_INCOMPLETE_CONDUCTOR_CAP.put(color, (ItemEntry<SequencedAssemblyItem>)REGISTRATE.item(colorReg + "_incomplete_conductor_cap", SequencedAssemblyItem::new).model((dataGenContext, itemModelProvider) -> ((ItemModelBuilder)itemModelProvider.withExistingParent(colorReg + "_incomplete_conductor_cap", itemModelProvider.modLoc("item/incomplete_conductor_cap"))).texture("cap", itemModelProvider.modLoc("entity/caps/" + colorReg + "_conductor_cap"))).lang("Incomplete " + colorName + " Conductor's Cap").register());
            ITEM_CONDUCTOR_CAP.put(color, (ItemEntry<ConductorCapItem>)REGISTRATE.item(colorReg + "_conductor_cap", p -> ConductorCapItem.create(p, color)).model((dataGenContext, itemModelProvider) -> ((ItemModelBuilder)itemModelProvider.withExistingParent(colorReg + "_conductor_cap", itemModelProvider.modLoc("item/conductor_cap"))).texture("cap", itemModelProvider.modLoc("entity/caps/" + colorReg + "_conductor_cap"))).lang(colorName + " Conductor's Cap").tag(new TagKey[]{CONDUCTOR_CAPS}).properties(p -> p.stacksTo(1)).recipe((ctx, prov) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ctx.get())).requires(CONDUCTOR_CAPS).requires(RailwaysRecipeProvider.Ingredients.dye(color)).unlockedBy("hasitem", RegistrateRecipeProvider.has(CONDUCTOR_CAPS)).save((RecipeOutput)prov, Railways.asResource("dying_existing_cap_" + colorReg))).register());
        }
        for (TrackMaterial material : TrackMaterial.allFromMod((String)"railways")) {
            ITEM_INCOMPLETE_TRACK.put(material, (ItemEntry<SequencedAssemblyItem>)REGISTRATE.item("track_incomplete_" + material.resourceName(), SequencedAssemblyItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{Railways.asResource("item/track_incomplete/" + c.getName())})).lang("Incomplete " + material.langName + " Track").register());
        }
    }
}

