/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.procedures;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.DivingHelmetItem;
import net.mcreator.createstuffadditions.init.CreateSaModItems;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;

@EventBusSubscriber
public final class NetheriteJetpackExoskeletonHandlerProcedure {
    public static final String NETHERITE_DIVING_BITS_KEY = "CreateStuffNetheriteDivingBits";
    public static final String FIRE_IMMUNE_KEY = "CreateStuffFireImmune";

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        EquipmentSlot slot = event.getSlot();
        if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ItemStack to = event.getTo();
        if (slot == EquipmentSlot.HEAD) {
            if (NetheriteJetpackExoskeletonHandlerProcedure.isNetheriteDivingHelmet(to)) {
                NetheriteJetpackExoskeletonHandlerProcedure.setBit(entity, slot);
            } else {
                NetheriteJetpackExoskeletonHandlerProcedure.clearBit(entity, slot);
            }
        } else if (slot == EquipmentSlot.CHEST) {
            if (NetheriteJetpackExoskeletonHandlerProcedure.isNetheriteBacktank(to) && BacktankUtil.hasAirRemaining((ItemStack)to)) {
                NetheriteJetpackExoskeletonHandlerProcedure.setBit(entity, slot);
            } else if (entity.getItemBySlot(EquipmentSlot.CHEST).getItem() == CreateSaModItems.NETHERITE_JETPACK_CHESTPLATE.get()) {
                NetheriteJetpackExoskeletonHandlerProcedure.setBit(entity, slot);
            } else {
                NetheriteJetpackExoskeletonHandlerProcedure.clearBit(entity, slot);
            }
        } else if (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET) {
            if (NetheriteJetpackExoskeletonHandlerProcedure.isNetheriteArmor(to)) {
                NetheriteJetpackExoskeletonHandlerProcedure.setBit(entity, slot);
            } else {
                NetheriteJetpackExoskeletonHandlerProcedure.clearBit(entity, slot);
            }
        }
    }

    public static boolean isNetheriteDivingHelmet(ItemStack stack) {
        return stack.getItem() instanceof DivingHelmetItem && NetheriteJetpackExoskeletonHandlerProcedure.isNetheriteArmor(stack);
    }

    public static boolean isNetheriteBacktank(ItemStack stack) {
        return stack.is(AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.tag) && NetheriteJetpackExoskeletonHandlerProcedure.isNetheriteArmor(stack);
    }

    public static boolean isNetheriteArmor(ItemStack stack) {
        return stack.getItem() instanceof ArmorItem && stack.has(DataComponents.FIRE_RESISTANT);
    }

    public static void setBit(LivingEntity entity, EquipmentSlot slot) {
        CompoundTag nbt = entity.getPersistentData();
        byte bits = nbt.getByte(NETHERITE_DIVING_BITS_KEY);
        if ((bits & 0xF) == 15) {
            return;
        }
        bits = (byte)(bits | 1 << slot.getIndex());
        nbt.putByte(NETHERITE_DIVING_BITS_KEY, bits);
        if ((bits & 0xF) == 15) {
            NetheriteJetpackExoskeletonHandlerProcedure.setFireImmune(entity, true);
        }
    }

    public static void clearBit(LivingEntity entity, EquipmentSlot slot) {
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.contains(NETHERITE_DIVING_BITS_KEY)) {
            return;
        }
        byte bits = nbt.getByte(NETHERITE_DIVING_BITS_KEY);
        boolean prevFullSet = (bits & 0xF) == 15;
        bits = (byte)(bits & ~(1 << slot.getIndex()));
        nbt.putByte(NETHERITE_DIVING_BITS_KEY, bits);
        if (prevFullSet) {
            NetheriteJetpackExoskeletonHandlerProcedure.setFireImmune(entity, false);
        }
    }

    public static void setFireImmune(LivingEntity entity, boolean fireImmune) {
        entity.getPersistentData().putBoolean(FIRE_IMMUNE_KEY, fireImmune);
    }
}

