/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.cit.conditions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import shcm.shsupercm.fabric.citresewn.api.CITConditionContainer;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.IntegerCondition;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.ListCondition;
import shcm.shsupercm.fabric.citresewn.defaults.cit.conditions.ConditionEnchantments;

public class ConditionEnchantmentLevels
extends ListCondition<EnchantmentLevelCondition> {
    public static final CITConditionContainer<ConditionEnchantmentLevels> CONTAINER = new CITConditionContainer(ConditionEnchantmentLevels.class, ConditionEnchantmentLevels::new, new String[]{"enchantment_levels", "enchantmentLevels"});
    protected Set<ResourceLocation> enchantments = null;

    public ConditionEnchantmentLevels() {
        super(EnchantmentLevelCondition.class, EnchantmentLevelCondition::new);
    }

    public Set<Class<? extends CITCondition>> siblingConditions() {
        return Set.of(ConditionEnchantments.class);
    }

    public <T extends CITCondition> T modifySibling(T sibling) {
        if (sibling instanceof ConditionEnchantments) {
            ConditionEnchantments conditionEnchantments = (ConditionEnchantments)sibling;
            if (this.enchantments == null) {
                this.enchantments = new HashSet<ResourceLocation>();
                for (EnchantmentLevelCondition subCondition : (EnchantmentLevelCondition[])this.conditions) {
                    subCondition.enchantments = this.enchantments;
                }
            }
            this.enchantments.addAll(Arrays.asList(conditionEnchantments.getEnchantments()));
        }
        return sibling;
    }

    protected static class EnchantmentLevelCondition
    extends IntegerCondition {
        protected Set<ResourceLocation> enchantments = null;

        protected EnchantmentLevelCondition() {
            super(true, false, false);
        }

        public boolean test(CITContext context) {
            for (Map.Entry entry : context.enchantments().entrySet()) {
                if (this.enchantments != null && !this.enchantments.contains(entry.getKey()) || entry.getValue() == null || !(this.range ? this.min <= (Integer)entry.getValue() && (Integer)entry.getValue() <= this.max : (Integer)entry.getValue() == this.min)) continue;
                return true;
            }
            return false;
        }
    }
}

