/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.cit.conditions;

import java.util.LinkedHashSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import shcm.shsupercm.fabric.citresewn.api.CITConditionContainer;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.IdentifierCondition;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.ListCondition;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public class ConditionItems
extends ListCondition<ItemCondition> {
    public static final CITConditionContainer<ConditionItems> CONTAINER = new CITConditionContainer(ConditionItems.class, ConditionItems::new, new String[]{"items", "matchItems"});
    public Item[] items = new Item[0];

    public ConditionItems() {
        super(ItemCondition.class, ItemCondition::new);
    }

    public ConditionItems(Item ... items) {
        this();
        this.items = items;
    }

    public void load(PropertyKey key, PropertyValue value, PropertyGroup properties) throws CITParsingException {
        super.load(key, value, properties);
        LinkedHashSet<Item> items = new LinkedHashSet<Item>();
        for (ItemCondition itemCondition : (ItemCondition[])this.conditions) {
            items.add(itemCondition.item);
        }
        this.items = items.toArray(new Item[0]);
    }

    public boolean test(CITContext context) {
        for (Item item : this.items) {
            if (context.stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    protected static class ItemCondition
    extends IdentifierCondition {
        public Item item = null;

        protected ItemCondition() {
        }

        public void load(PropertyKey key, PropertyValue value, PropertyGroup properties) throws CITParsingException {
            super.load(key, value, properties);
            if (BuiltInRegistries.ITEM.containsKey(this.value)) {
                this.item = (Item)BuiltInRegistries.ITEM.get(this.value);
            } else {
                this.item = null;
                this.warn(String.valueOf(this.value) + " is not in the item registry", value, properties);
            }
        }

        protected ResourceLocation getValue(CITContext context) {
            return this.value;
        }
    }
}

