/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.cit.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import shcm.shsupercm.fabric.citresewn.api.CITTypeContainer;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.CITCache;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.defaults.cit.conditions.ConditionItems;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public class TypeElytra
extends CITType {
    public static final Container CONTAINER = new Container();
    public ResourceLocation texture;

    public Set<PropertyKey> typeProperties() {
        return Set.of(PropertyKey.of((String)"texture"));
    }

    public void load(List<CITCondition> conditions, PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        for (CITCondition condition : conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            ConditionItems items = (ConditionItems)condition;
            for (Item item : items.items) {
                if (item instanceof ElytraItem) continue;
                this.warn("Non elytra item type condition", null, properties);
            }
        }
        this.texture = TypeElytra.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)properties.getLastWithoutMetadata("citresewn", new String[]{"texture"}), (String)"textures", (String)".png", (ResourceManager)resourceManager);
        if (this.texture == null) {
            throw new CITParsingException("Texture not specified", properties, -1);
        }
    }

    public static class Container
    extends CITTypeContainer<TypeElytra> {
        public final List<Function<LivingEntity, ItemStack>> getItemInSlotCompatRedirects = new ArrayList<Function<LivingEntity, ItemStack>>();
        public Set<CIT<TypeElytra>> loaded = new HashSet<CIT<TypeElytra>>();

        public Container() {
            super(TypeElytra.class, TypeElytra::new, "elytra");
        }

        public void load(List<CIT<TypeElytra>> parsedCITs) {
            this.loaded.addAll(parsedCITs);
        }

        public void dispose() {
            this.loaded.clear();
        }

        public CIT<TypeElytra> getCIT(CITContext context) {
            return (CIT)((CITCacheElytra)context.stack).citresewn$getCacheTypeElytra().get(context).get();
        }

        public CIT<TypeElytra> getRealTimeCIT(CITContext context) {
            for (CIT<TypeElytra> cit : this.loaded) {
                if (!cit.test(context)) continue;
                return cit;
            }
            return null;
        }

        public ItemStack getVisualElytraItem(LivingEntity entity) {
            for (Function<LivingEntity, ItemStack> redirect : this.getItemInSlotCompatRedirects) {
                ItemStack stack = redirect.apply(entity);
                if (stack == null) continue;
                return stack;
            }
            return entity.getItemBySlot(EquipmentSlot.CHEST);
        }
    }

    public static interface CITCacheElytra {
        public CITCache.Single<TypeElytra> citresewn$getCacheTypeElytra();
    }
}

