/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

public class CoralEnderman
extends BaseEnderman {
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public CoralEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 6;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new CoralEndermanMoveControl();
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.13).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnCoralEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return BaseEnderman.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean checkSpawnRules(EntityType<CoralEnderman> enderman, ServerLevelAccessor serverLevel, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        if (!EndermanOverhaulConfig.spawnCoralEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        if (!serverLevel.getFluidState(pos.below()).is(FluidTags.WATER)) {
            return false;
        }
        boolean bl = serverLevel.getDifficulty() != Difficulty.PEACEFUL && CoralEnderman.isDarkEnoughToSpawn((ServerLevelAccessor)serverLevel, (BlockPos)pos, (RandomSource)random) && (mobSpawnType == MobSpawnType.SPAWNER || serverLevel.getFluidState(pos).is(FluidTags.WATER));
        return random.nextInt(40) == 0 && pos.getY() < serverLevel.getSeaLevel() - 5 && bl;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 0, state -> {
            if (this.isInWater()) {
                state.getController().setAnimation(ConstantAnimations.SWIM);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation((double)state.getLimbSwingAmount() > 0.1 || (double)state.getLimbSwingAmount() < -0.1 ? ConstantAnimations.WALK : ConstantAnimations.IDLE);
            return PlayState.CONTINUE;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.getAttackAnim(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        }));
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BaseEnderman.EndermanFreezeWhenLookedAt(this));
        this.goalSelector.addGoal(1, (Goal)new CoralEndermanSwimGoal());
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new BaseEnderman.EndermanLookForPlayerGoal(this, arg_0 -> ((CoralEnderman)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    @Nullable
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.BUBBLE.get();
    }

    @Override
    public int getParticleCount() {
        return 1;
    }

    @Override
    public int getParticleRate() {
        return 4;
    }

    @Override
    public boolean canPickupBlocks() {
        return false;
    }

    @Override
    public boolean canTeleport() {
        return this.isCreepy() || this.getAirSupply() <= 20;
    }

    @Override
    public double getVisionRange() {
        return 64.0;
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    public void baseTick() {
        int airSupply = this.getAirSupply();
        super.baseTick();
        this.handleAirSupply(airSupply);
    }

    @Override
    public boolean speedUpWhenAngry() {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(0.01f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
        super.travel(travelVector);
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.level().getBlockState(this.blockPosition().above().above()).is(Blocks.WATER)) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigation;
                this.setSwimming(false);
            }
        }
        super.updateSwimming();
    }

    protected void handleAirSupply(int airSupply) {
        if (this.isAlive() && !this.isInWaterOrBubble()) {
            this.setAirSupply(airSupply - 1);
            if (this.getAirSupply() <= 20 && this.getTickCount() % 20 == 0 && !this.teleportToWater()) {
                for (int i = 0; i < 64 && !this.teleport(); ++i) {
                }
            }
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    private boolean teleportToWater() {
        RandomSource randomSource = this.getRandom();
        BlockPos blockPos = this.blockPosition();
        for (int i = 0; i < 100; ++i) {
            BlockPos blockPos2 = blockPos.offset(randomSource.nextInt(30) - 10, 2 - randomSource.nextInt(8), randomSource.nextInt(30) - 10);
            if (!this.level().getBlockState(blockPos2).is(Blocks.WATER)) continue;
            Vec3 pos = Vec3.atBottomCenterOf((Vec3i)blockPos2);
            this.level().gameEvent((Holder)GameEvent.TELEPORT, this.position(), GameEvent.Context.of((Entity)this));
            this.teleportTo(pos.x() + 0.5, pos.y(), pos.z() + 0.5);
            this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private class CoralEndermanMoveControl
    extends MoveControl {
        CoralEndermanMoveControl() {
            super((Mob)CoralEnderman.this);
        }

        public void tick() {
            if (!CoralEnderman.this.isInWater()) {
                super.tick();
                return;
            }
            LivingEntity livingEntity = CoralEnderman.this.getTarget();
            if (livingEntity != null && livingEntity.getY() > CoralEnderman.this.getY()) {
                CoralEnderman.this.setDeltaMovement(CoralEnderman.this.getDeltaMovement().add(0.0, 0.002, 0.0));
            }
            if (this.operation != MoveControl.Operation.MOVE_TO || CoralEnderman.this.getNavigation().isDone()) {
                CoralEnderman.this.setSpeed(0.0f);
                return;
            }
            double d = this.wantedX - CoralEnderman.this.getX();
            double e = this.wantedY - CoralEnderman.this.getY();
            double f = this.wantedZ - CoralEnderman.this.getZ();
            double g = Math.sqrt(d * d + e * e + f * f);
            e /= g;
            float h = (float)(Mth.atan2((double)f, (double)d) * 57.2957763671875) - 90.0f;
            CoralEnderman.this.setYRot(this.rotlerp(CoralEnderman.this.getYRot(), h, 90.0f));
            CoralEnderman.this.yBodyRot = CoralEnderman.this.getYRot();
            float i = (float)(this.speedModifier * CoralEnderman.this.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float j = Mth.lerp((float)0.125f, (float)CoralEnderman.this.getSpeed(), (float)i);
            CoralEnderman.this.setSpeed(j);
            CoralEnderman.this.setDeltaMovement(CoralEnderman.this.getDeltaMovement().add((double)(j *= 15.0f) * d * 0.005, (double)j * e * 0.025, (double)j * f * 0.005));
            if (CoralEnderman.this.isCreepy()) {
                CoralEnderman.this.addDeltaMovement(new Vec3(CoralEnderman.this.getDeltaMovement().x * 0.18, 0.0, CoralEnderman.this.getDeltaMovement().z * 0.18));
            }
        }
    }

    private class CoralEndermanSwimGoal
    extends RandomSwimmingGoal {
        public CoralEndermanSwimGoal() {
            super((PathfinderMob)CoralEnderman.this, 1.0, 40);
        }

        public boolean canUse() {
            return super.canUse() && !CoralEnderman.this.isCreepy();
        }
    }
}

