/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.projectiles;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.base.BaseThrownPearl;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.endermanoverhaul.common.utils.ModUtils;

public class ThrownIcyPearl
extends BaseThrownPearl {
    public ThrownIcyPearl(EntityType<? extends ThrownIcyPearl> type, Level level) {
        super(type, level);
    }

    public ThrownIcyPearl(Level level, LivingEntity shooter) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntityTypes.ICY_PEARL.get()), shooter, level);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.ICY_PEARL.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 4.0f);
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        if (this.level().isClientSide() || this.isRemoved()) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            ModUtils.sendParticles((ServerLevel)this.level(), ParticleTypes.PORTAL, this.getX(), this.getY() - 1.0 + this.random.nextDouble() * 2.0, this.getZ(), 1, 0.0, 0.0, 0.0, -1.3);
            ModUtils.sendParticles((ServerLevel)this.level(), ParticleTypes.SNOWFLAKE, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), 1, 0.5, 0.5, 0.5, 0.05);
        }
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.connection.isAcceptingMessages() && serverPlayer.level() == this.level() && !serverPlayer.isSleeping()) {
                List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(4.0), e -> e instanceof LivingEntity);
                for (Entity nearby : nearbyEntities) {
                    if (nearby == serverPlayer || !(nearby instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)nearby;
                    target.setTicksFrozen(target.getTicksRequiredToFreeze() * 5);
                    target.hurt(this.damageSources().freeze(), 8.0f);
                    target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 2));
                    target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 400, 1));
                }
                BlockPos.betweenClosedStream((int)Mth.floor((double)(this.getX() - 1.0)), (int)Mth.floor((double)(this.getY() - 1.0)), (int)Mth.floor((double)(this.getZ() - 1.0)), (int)Mth.floor((double)(this.getX() + 1.0)), (int)Mth.floor((double)(this.getY() + 1.0)), (int)Mth.floor((double)(this.getZ() + 1.0))).filter(pos -> this.level().getFluidState(pos).is(FluidTags.WATER)).forEach(pos -> this.level().setBlockAndUpdate(pos, Blocks.FROSTED_ICE.defaultBlockState()));
                if (serverPlayer.connection.isAcceptingMessages() && serverPlayer.level() == this.level() && !serverPlayer.isSleeping()) {
                    if (entity.isPassenger()) {
                        serverPlayer.dismountTo(this.getX(), this.getY(), this.getZ());
                    } else if (this.level().getBlockState(this.blockPosition()).is(Blocks.FROSTED_ICE)) {
                        if (this.level().getBlockState(this.blockPosition().above()).is(Blocks.FROSTED_ICE)) {
                            entity.teleportTo(this.getX(), this.getY() + 2.0, this.getZ());
                        } else {
                            entity.teleportTo(this.getX(), this.getY() + 1.0, this.getZ());
                        }
                    } else {
                        entity.teleportTo(this.getX(), this.getY(), this.getZ());
                    }
                    entity.hurt(this.damageSources().fall(), 5.0f);
                    entity.resetFallDistance();
                }
            }
        } else if (entity != null) {
            entity.teleportTo(this.getX(), this.getY(), this.getZ());
            entity.resetFallDistance();
        }
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSoundEvents.ICY_PEARL_HIT.get(), this.getSoundSource(), 1.0f, 1.0f);
        this.discard();
    }
}

