/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.shuffle.client;

import com.diontryban.ash_api.client.event.ClientTickEvent;
import com.diontryban.ash_api.client.gui.screens.ModOptionsScreenRegistry;
import com.diontryban.ash_api.client.input.KeyMappingRegistry;
import com.diontryban.ash_api.event.UseBlockEvent;
import com.diontryban.shuffle.Shuffle;
import com.diontryban.shuffle.client.gui.screens.ShuffleOptionsScreen;
import com.diontryban.shuffle.options.ShuffleOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;

public class ShuffleClient {
    private static KeyMapping keyMapping;
    private static boolean shuffle;
    private static boolean keyWasDown;
    private static int slotToSwitchTo;

    public static void init() {
        keyMapping = KeyMappingRegistry.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shuffle", (String)"shuffle"), (int)82, (String)"shuffle");
        ModOptionsScreenRegistry.register(Shuffle.OPTIONS, ShuffleOptionsScreen::new);
        ClientTickEvent.Pre.register(ShuffleClient::onClientTickPre);
        UseBlockEvent.register(ShuffleClient::onUseBlock);
    }

    private static void onClientTickPre(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        if (keyMapping.isDown() && !keyWasDown) {
            keyWasDown = true;
            boolean bl = shuffle = !shuffle;
            if (shuffle) {
                player.displayClientMessage((Component)Component.translatable((String)"message.shuffle.enable"), true);
                if (((ShuffleOptions)Shuffle.OPTIONS.get()).playSoundEffects) {
                    player.playSound(SoundEvents.TRIPWIRE_CLICK_OFF, 0.5f, 1.0f);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.shuffle.disable"), true);
                if (((ShuffleOptions)Shuffle.OPTIONS.get()).playSoundEffects) {
                    player.playSound(SoundEvents.TRIPWIRE_CLICK_ON, 0.5f, 1.0f);
                }
            }
        } else if (!keyMapping.isDown() && keyWasDown) {
            keyWasDown = false;
        }
        if (slotToSwitchTo >= 0 && slotToSwitchTo <= 8) {
            player.getInventory().selected = slotToSwitchTo;
            slotToSwitchTo = -1;
        }
    }

    private static InteractionResult onUseBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        Item itemInHand;
        if (shuffle && level.isClientSide && !player.isSpectator() && Block.byItem((Item)(itemInHand = player.getItemInHand(hand).getItem())) != Blocks.AIR) {
            NonNullList items = player.getInventory().items;
            slotToSwitchTo = ((ShuffleOptions)Shuffle.OPTIONS.get()).useWeightedRandom ? ShuffleClient.switchSlotWeighted((NonNullList<ItemStack>)items, level.random) : ShuffleClient.switchSlotRandom((NonNullList<ItemStack>)items, level.random);
        }
        return InteractionResult.PASS;
    }

    private static int switchSlotRandom(NonNullList<ItemStack> items, RandomSource random) {
        return ShuffleClient.switchSlotLogic(items, random, (i, stack) -> i, (list, rand) -> (Integer)list.get(rand.nextInt(list.size())));
    }

    private static int switchSlotWeighted(NonNullList<ItemStack> items, RandomSource random) {
        return ShuffleClient.switchSlotLogic(items, random, (i, stack) -> WeightedEntry.wrap((Object)i, (int)stack.getCount()), (list, rand) -> WeightedRandom.getRandomItem((RandomSource)rand, (List)list).map(WeightedEntry.Wrapper::data).orElse(-1));
    }

    private static <T> int switchSlotLogic(NonNullList<ItemStack> items, RandomSource random, BiFunction<Integer, ItemStack, T> createEntry, ToIntBiFunction<List<T>, RandomSource> pickRandom) {
        ArrayList<T> slotsWithBlocks = new ArrayList<T>();
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (Block.byItem((Item)stack.getItem()) == Blocks.AIR || ((ShuffleOptions)Shuffle.OPTIONS.get()).lockedSlots[i]) continue;
            slotsWithBlocks.add(createEntry.apply(i, stack));
        }
        return !slotsWithBlocks.isEmpty() ? pickRandom.applyAsInt(slotsWithBlocks, random) : -1;
    }

    static {
        shuffle = false;
        keyWasDown = false;
        slotToSwitchTo = -1;
    }
}

