/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.entity.player.McGameProfile;

public final class ModPlayerSkins {
    private static final Cache<UUID, Supplier<ResourceLocation>> SKINS = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static synchronized void loadSkin(@NotNull UUID playerId, @NotNull String nick, @NotNull ScheduledExecutorService backgroundExecutor) {
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(playerId);
        if (playerInfo != null) {
            return;
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return;
        }
        backgroundExecutor.execute(() -> {
            GameProfile profile = Optional.ofNullable(Minecraft.getInstance().getMinecraftSessionService().fetchProfile(playerId, false)).map(ProfileResult::profile).orElse(new GameProfile(playerId, nick));
            SKINS.put((Object)profile.getId(), ModPlayerSkins.getInsecureSkinLocation(profile));
        });
    }

    public static synchronized void loadSkin(@NotNull McGameProfile gameProfile) {
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(gameProfile.getId());
        if (playerInfo != null) {
            return;
        }
        Supplier<ResourceLocation> skinLocation = (Supplier<ResourceLocation>)SKINS.getIfPresent((Object)gameProfile.getId());
        if (skinLocation != null) {
            return;
        }
        GameProfile profile = new GameProfile(gameProfile.getId(), gameProfile.getName());
        gameProfile.getProperties().forEach(property -> profile.getProperties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature())));
        skinLocation = ModPlayerSkins.getInsecureSkinLocation(profile);
        SKINS.put((Object)gameProfile.getId(), skinLocation);
    }

    private static Supplier<ResourceLocation> getInsecureSkinLocation(GameProfile gameProfile) {
        Supplier skinSupplier = Minecraft.getInstance().getSkinManager().lookupInsecure(gameProfile);
        return () -> ModPlayerSkins.lambda$getInsecureSkinLocation$2((Supplier)skinSupplier);
    }

    @NotNull
    public static synchronized ResourceLocation getSkin(@NotNull UUID playerId, @NotNull String nick) {
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(playerId);
        if (playerInfo != null) {
            return playerInfo.getSkin().texture();
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return (ResourceLocation)skinLocation.get();
        }
        return ModPlayerSkins.getDefaultSkin(playerId);
    }

    @NotNull
    public static ResourceLocation getDefaultSkin(@NotNull UUID playerId) {
        return DefaultPlayerSkin.get((UUID)playerId).texture();
    }

    private ModPlayerSkins() {
    }

    private static /* synthetic */ ResourceLocation lambda$getInsecureSkinLocation$2(Supplier skinSupplier) {
        ResourceLocation skinLocation = ((PlayerSkin)skinSupplier.get()).texture();
        Minecraft.getInstance().getTextureManager().getTexture(skinLocation).setFilter(false, true);
        return skinLocation;
    }
}

