/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AlContextAudioDevice;
import su.plo.voice.api.client.audio.device.AlContextOutputDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.source.AlSource;
import su.plo.voice.api.client.audio.device.source.AlSourceParams;
import su.plo.voice.api.client.audio.source.LoopbackSource;
import su.plo.voice.client.config.VoiceClientConfig;

public final class ClientLoopbackSource
implements LoopbackSource {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final boolean relative;
    private final float[] position = new float[3];
    @Nullable
    private AlSource source;
    private boolean stereo;
    private DoubleConfigEntry volumeEntry;

    @Override
    @NotNull
    public Optional<AlSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    @Override
    public void initialize(boolean stereo) throws DeviceException {
        AlContextOutputDevice device = this.voiceClient.getDeviceManager().getOutputDevice().orElseThrow(() -> new DeviceException("Output device is null"));
        this.stereo = stereo;
        this.source = (AlSource)device.createSource(stereo, AlSourceParams.DEFAULT);
        this.source.setCloseTimeoutMs(0L);
        device.runInContextBlocking(() -> {
            this.source.setFloat(4110, 4.0f);
            if (this.relative) {
                this.source.setInt(514, 1);
            }
            this.source.play();
        });
    }

    @Override
    public void close() {
        if (this.source == null) {
            return;
        }
        this.source.closeAsync();
        this.source = null;
    }

    @Override
    public boolean isClosed() {
        return this.source == null || this.source.isClosed();
    }

    @Override
    public void write(short[] samples) {
        if (this.source == null) {
            return;
        }
        if (!this.relative) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            this.position[0] = (float)player.getX();
            this.position[1] = (float)(player.getY() + (double)player.getEyeHeight());
            this.position[2] = (float)player.getZ();
        }
        float volume = ((Double)this.config.getVoice().getVolume().value()).floatValue();
        if (this.volumeEntry != null) {
            volume *= ((Double)this.volumeEntry.value()).floatValue();
        }
        if (((Boolean)this.config.getAdvanced().getExponentialVolumeSlider().value()).booleanValue()) {
            volume = (float)Math.pow(volume, 3.0);
        }
        this.updateSources(volume);
        this.source.write(samples, true);
    }

    private void updateSources(float volume) {
        AlContextAudioDevice device = this.source.getDevice();
        device.runInContextBlocking(() -> {
            this.source.setVolume(volume);
            if (!this.relative) {
                this.source.setFloatArray(4100, this.position);
            }
        });
    }

    public ClientLoopbackSource(PlasmoVoiceClient voiceClient, VoiceClientConfig config, boolean relative) {
        this.voiceClient = voiceClient;
        this.config = config;
        this.relative = relative;
    }

    @Override
    public boolean isStereo() {
        return this.stereo;
    }

    @Override
    public void setVolumeEntry(DoubleConfigEntry volumeEntry) {
        this.volumeEntry = volumeEntry;
    }
}

