/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.connection;

import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.mod.channel.ByteArrayPayload;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.connection.ModServerConnection;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;

public final class ModClientChannelHandler
implements IPayloadHandler<ByteArrayPayload> {
    private final BaseVoiceClient voiceClient;
    private ModServerConnection connection;

    public ModClientChannelHandler(@NotNull BaseVoiceClient voiceClient) {
        this.voiceClient = voiceClient;
    }

    public void close() {
        if (this.connection != null) {
            this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.connection);
            this.connection = null;
        }
    }

    public Optional<ServerConnection> getConnection() {
        return Optional.ofNullable(this.connection);
    }

    public void handle(@NotNull ByteArrayPayload payload, @NotNull IPayloadContext context) {
        this.receive(context.connection(), payload.getData());
    }

    private void receive(Connection connection, Packet<PacketHandler> packet) {
        if (this.connection == null || connection != this.connection.getConnection()) {
            if (this.connection != null) {
                this.close();
            }
            try {
                this.connection = new ModServerConnection(this.voiceClient, connection);
                this.connection.generateKeyPair();
                this.voiceClient.getEventBus().register(this.voiceClient, this.connection);
            }
            catch (Exception e) {
                BaseVoice.LOGGER.error("Failed to initialize server connection: {}", e.toString());
                e.printStackTrace();
                return;
            }
        }
        this.connection.handle(packet);
    }

    private void receive(Connection connection, FriendlyByteBuf buf) {
        this.receive(connection, ByteBufUtil.getBytes((ByteBuf)buf.duplicate()));
    }

    private void receive(Connection connection, byte[] data) {
        try {
            PacketTcpCodec.decode(ByteStreams.newDataInput((byte[])data)).ifPresent(packet -> this.receive(connection, (Packet<PacketHandler>)packet));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

