/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.recipe;

import java.util.stream.Stream;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;

public class CookingRecipes {
    public static final int FAST_COOKING = 100;
    public static final int NORMAL_COOKING = 200;
    public static final int SLOW_COOKING = 400;
    public static final float SMALL_EXP = 0.35f;
    public static final float MEDIUM_EXP = 1.0f;
    public static final float LARGE_EXP = 2.0f;

    public static void register(RecipeOutput output) {
        CookingRecipes.cookMiscellaneous(output);
        CookingRecipes.cookMinecraftSoups(output);
        CookingRecipes.cookMeals(output);
    }

    private static Ingredient vegetablesPatch() {
        return DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.FOODS_VEGETABLE), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}));
    }

    private static void cookMiscellaneous(RecipeOutput output) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.HOT_COCOA.get(), 1, 200, 1.0f).addIngredient((TagKey<Item>)Tags.Items.DRINKS_MILK).addIngredient((ItemLike)Items.SUGAR).addIngredient((ItemLike)Items.COCOA_BEANS).addIngredient((ItemLike)Items.COCOA_BEANS).unlockedByAnyIngredient(new ItemLike[]{Items.COCOA_BEANS, Items.MILK_BUCKET, (ItemLike)ModItems.MILK_BOTTLE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.APPLE_CIDER.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.APPLE).addIngredient((ItemLike)Items.APPLE).addIngredient((ItemLike)Items.SUGAR).unlockedByItems("has_apple", new ItemLike[]{Items.APPLE}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.TOMATO_SAUCE.get(), 1, 100, 0.35f).addIngredient(CommonTags.CROPS_TOMATO).addIngredient(CommonTags.CROPS_TOMATO).unlockedByItems("has_tomato", (ItemLike)ModItems.TOMATO.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.DOG_FOOD.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.ROTTEN_FLESH).addIngredient((ItemLike)Items.BONE_MEAL).addIngredient((TagKey<Item>)Tags.Items.FOODS_RAW_MEAT).addIngredient(CommonTags.CROPS_RICE).unlockedByAnyIngredient(new ItemLike[]{Items.ROTTEN_FLESH, Items.BONE_MEAL, (ItemLike)ModItems.RICE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.GLOW_BERRY_CUSTARD.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.GLOW_BERRIES).addIngredient((TagKey<Item>)Tags.Items.DRINKS_MILK).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient((ItemLike)Items.SUGAR).unlockedByAnyIngredient(new ItemLike[]{Items.GLOW_BERRIES, Items.MILK_BUCKET, (ItemLike)ModItems.MILK_BOTTLE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output);
    }

    private static void cookMinecraftSoups(RecipeOutput output) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.MUSHROOM_STEW, 1, 200, 1.0f, (ItemLike)Items.BOWL).addIngredient((ItemLike)Items.BROWN_MUSHROOM).addIngredient((ItemLike)Items.RED_MUSHROOM).unlockedByAnyIngredient(new ItemLike[]{Blocks.BROWN_MUSHROOM, Blocks.RED_MUSHROOM}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.BEETROOT_SOUP, 1, 200, 1.0f, (ItemLike)Items.BOWL).addIngredient((ItemLike)Items.BEETROOT).addIngredient((ItemLike)Items.BEETROOT).addIngredient((ItemLike)Items.BEETROOT).unlockedByItems("has_beetroot", new ItemLike[]{Items.BEETROOT}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.RABBIT_STEW, 1, 200, 1.0f, (ItemLike)Items.BOWL).addIngredient((ItemLike)Items.BAKED_POTATO).addIngredient((ItemLike)Items.RABBIT).addIngredient((ItemLike)Items.CARROT).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_MUSHROOM, Items.RED_MUSHROOM})).unlockedByAnyIngredient(new ItemLike[]{Items.RABBIT, Items.BROWN_MUSHROOM, Items.RED_MUSHROOM, Items.CARROT, Items.BAKED_POTATO}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
    }

    private static void cookMeals(RecipeOutput output) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.BAKED_COD_STEW.get(), 1, 200, 1.0f).addIngredient(CommonTags.FOODS_RAW_COD).addIngredient((ItemLike)Items.POTATO).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(CommonTags.CROPS_TOMATO).unlockedByAnyIngredient(new ItemLike[]{Items.COD, Items.POTATO, (ItemLike)ModItems.TOMATO.get(), Items.EGG}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.BEEF_STEW.get(), 1, 200, 1.0f).addIngredient(CommonTags.FOODS_RAW_BEEF).addIngredient((ItemLike)Items.CARROT).addIngredient((ItemLike)Items.POTATO).unlockedByAnyIngredient(new ItemLike[]{Items.BEEF, Items.CARROT, Items.POTATO}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.BONE_BROTH.get(), 1, 200, 0.35f).addIngredient((TagKey<Item>)Tags.Items.BONES).addIngredient(Ingredient.fromValues(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)Items.GLOW_BERRIES)), new Ingredient.TagValue(Tags.Items.MUSHROOMS), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.HANGING_ROOTS)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.GLOW_LICHEN))))).unlockedByItems("has_bone", new ItemLike[]{Items.BONE}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.CABBAGE_ROLLS.get(), 1, 100, 0.35f).addIngredient(CommonTags.CROPS_CABBAGE).addIngredient(ModTags.CABBAGE_ROLL_INGREDIENTS).unlockedByAnyIngredient((ItemLike)ModItems.CABBAGE.get(), (ItemLike)ModItems.CABBAGE_LEAF.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.CHICKEN_SOUP.get(), 1, 200, 1.0f).addIngredient(CommonTags.FOODS_RAW_CHICKEN).addIngredient((ItemLike)Items.CARROT).addIngredient(CommonTags.FOODS_LEAFY_GREEN).addIngredient(CookingRecipes.vegetablesPatch()).unlockedByAnyIngredient(new ItemLike[]{Items.CHICKEN, Items.CARROT}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.COOKED_RICE.get(), 1, 100, 0.35f).addIngredient(CommonTags.CROPS_RICE).unlockedByItems("has_rice", (ItemLike)ModItems.RICE.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.DUMPLINGS.get(), 2, 200, 1.0f).addIngredient(CommonTags.FOODS_DOUGH).addIngredient(CommonTags.CROPS_CABBAGE).addIngredient(CommonTags.CROPS_ONION).addIngredient(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(CommonTags.FOODS_RAW_CHICKEN), new Ingredient.TagValue(CommonTags.FOODS_RAW_PORK), new Ingredient.TagValue(CommonTags.FOODS_RAW_BEEF), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.BROWN_MUSHROOM))))).unlockedByAnyIngredient((ItemLike)ModItems.WHEAT_DOUGH.get(), (ItemLike)ModItems.CABBAGE.get(), (ItemLike)ModItems.ONION.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.FISH_STEW.get(), 1, 200, 1.0f).addIngredient(CommonTags.FOODS_SAFE_RAW_FISH).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).addIngredient(CommonTags.CROPS_ONION).unlockedByAnyIngredient(new ItemLike[]{Items.SALMON, Items.COD, Items.TROPICAL_FISH, (ItemLike)ModItems.TOMATO_SAUCE.get(), (ItemLike)ModItems.ONION.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.FRIED_RICE.get(), 1, 200, 1.0f).addIngredient(CommonTags.CROPS_RICE).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient((ItemLike)Items.CARROT).addIngredient(CommonTags.CROPS_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RICE.get(), Items.EGG, Items.CARROT, (ItemLike)ModItems.ONION.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.MUSHROOM_RICE.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.BROWN_MUSHROOM).addIngredient((ItemLike)Items.RED_MUSHROOM).addIngredient(CommonTags.CROPS_RICE).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT, Items.POTATO})).unlockedByAnyIngredient(new ItemLike[]{Blocks.BROWN_MUSHROOM, Blocks.RED_MUSHROOM, (ItemLike)ModItems.RICE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.NOODLE_SOUP.get(), 1, 200, 1.0f).addIngredient(CommonTags.FOODS_PASTA).addIngredient(CommonTags.FOODS_COOKED_EGG).addIngredient((ItemLike)Items.DRIED_KELP).addIngredient(CommonTags.FOODS_RAW_PORK).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.DRIED_KELP, Items.PORKCHOP}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PASTA_WITH_MEATBALLS.get(), 1, 200, 1.0f).addIngredient((ItemLike)ModItems.MINCED_BEEF.get()).addIngredient(CommonTags.FOODS_PASTA).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.BEEF, (ItemLike)ModItems.TOMATO_SAUCE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PASTA_WITH_MUTTON_CHOP.get(), 1, 200, 1.0f).addIngredient(CommonTags.FOODS_RAW_MUTTON).addIngredient(CommonTags.FOODS_PASTA).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.MUTTON, (ItemLike)ModItems.TOMATO_SAUCE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.PUMPKIN_SOUP.get(), 1, 200, 1.0f).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).addIngredient(CommonTags.FOODS_LEAFY_GREEN).addIngredient(CommonTags.FOODS_RAW_PORK).addIngredient((TagKey<Item>)Tags.Items.DRINKS_MILK).unlockedByAnyIngredient(new ItemLike[]{Items.PUMPKIN, (ItemLike)ModItems.PUMPKIN_SLICE.get(), Items.PORKCHOP, Items.MILK_BUCKET, (ItemLike)ModItems.MILK_BOTTLE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.RATATOUILLE.get(), 1, 200, 1.0f).addIngredient(CommonTags.CROPS_TOMATO).addIngredient(CommonTags.CROPS_ONION).addIngredient((ItemLike)Items.BEETROOT).addIngredient(CookingRecipes.vegetablesPatch()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.TOMATO.get(), (ItemLike)ModItems.ONION.get(), Items.BEETROOT}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.SQUID_INK_PASTA.get(), 1, 200, 1.0f).addIngredient(CommonTags.FOODS_SAFE_RAW_FISH).addIngredient(CommonTags.FOODS_PASTA).addIngredient(CommonTags.CROPS_TOMATO).addIngredient((ItemLike)Items.INK_SAC).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.INK_SAC, (ItemLike)ModItems.TOMATO.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.STUFFED_PUMPKIN_BLOCK.get(), 1, 400, 2.0f, (ItemLike)Items.PUMPKIN).addIngredient(CommonTags.CROPS_RICE).addIngredient(CommonTags.CROPS_ONION).addIngredient((ItemLike)Items.BROWN_MUSHROOM).addIngredient((ItemLike)Items.POTATO).addIngredient((TagKey<Item>)Tags.Items.FOODS_BERRY).addIngredient(CookingRecipes.vegetablesPatch()).unlockedByItems("has_pumpkin", new ItemLike[]{Blocks.PUMPKIN}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.VEGETABLE_NOODLES.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.CARROT).addIngredient((ItemLike)Items.BROWN_MUSHROOM).addIngredient(CommonTags.FOODS_PASTA).addIngredient(CommonTags.FOODS_LEAFY_GREEN).addIngredient(CookingRecipes.vegetablesPatch()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.RAW_PASTA.get(), Items.BROWN_MUSHROOM, Items.CARROT}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)ModItems.VEGETABLE_SOUP.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.CARROT).addIngredient((ItemLike)Items.POTATO).addIngredient((ItemLike)Items.BEETROOT).addIngredient(CommonTags.FOODS_LEAFY_GREEN).unlockedByAnyIngredient(new ItemLike[]{Items.CARROT, (ItemLike)ModItems.ONION.get(), Items.BEETROOT}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
    }
}

