/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.pack.format;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertySeparator;

public class PropertiesGroupAdapter
extends PropertyGroup {
    public static final String EXTENSION = ".properties";

    protected PropertiesGroupAdapter(String packName, ResourceLocation identifier) {
        super(packName, identifier);
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public PropertyGroup load(String packName, ResourceLocation identifier, InputStream is) throws IOException, ResourceLocationException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            Object line;
            int linePos = 0;
            int multilineSkip = 0;
            while ((line = reader.readLine()) != null) {
                ++linePos;
                if (((String)(line = ((String)line).stripLeading())).isEmpty() || ((String)line).startsWith("#") || ((String)line).startsWith("!")) continue;
                while (((String)line).endsWith("\\")) {
                    String nextLine = reader.readLine();
                    ++linePos;
                    ++multilineSkip;
                    if (nextLine == null) {
                        nextLine = "";
                    }
                    if ((nextLine = nextLine.stripLeading()).startsWith("#") || nextLine.startsWith("!")) continue;
                    line = ((String)line).substring(0, ((String)line).length() - 1) + "\\n" + nextLine;
                }
                line = ((String)line).stripTrailing();
                StringBuilder builder = new StringBuilder();
                String key = null;
                String keyMetadata = null;
                boolean checkColonSeparator = !((String)line).contains("=");
                for (int i = 0; i < ((String)line).length(); ++i) {
                    int c = ((String)line).charAt(i);
                    if (c == 92) {
                        int n;
                        c = ((String)line).charAt(++i);
                        switch (c) {
                            case 110: {
                                int n2;
                                n = n2 = 10;
                                break;
                            }
                            case 114: {
                                int n2;
                                n = n2 = 13;
                                break;
                            }
                            case 102: {
                                int n2;
                                n = n2 = 12;
                                break;
                            }
                            case 116: {
                                int n2;
                                n = n2 = 9;
                                break;
                            }
                            case 117: {
                                int n2;
                                try {
                                    n = n2 = (int)((char)Integer.parseInt(((String)line).substring((i += 4) - 3, i + 1), 16));
                                    break;
                                }
                                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                                    throw new IOException("Malformatted escaped unicode character");
                                }
                            }
                            default: {
                                int n2;
                                n = n2 = (int)c;
                            }
                        }
                        c = n;
                    } else if (key == null && (c == 61 || checkColonSeparator && c == 58)) {
                        key = builder.toString().stripTrailing();
                        int metadataIndex = key.indexOf(46);
                        if (metadataIndex >= 0) {
                            keyMetadata = key.substring(metadataIndex + 1);
                            key = key.substring(0, metadataIndex);
                        }
                        builder = new StringBuilder();
                        ++i;
                        while (i < ((String)line).length() && Character.isWhitespace(((String)line).charAt(i))) {
                            ++i;
                        }
                        --i;
                        continue;
                    }
                    builder.append((char)c);
                }
                if (key == null) {
                    throw new IOException("Missing separator in line " + linePos);
                }
                int pos = linePos - multilineSkip;
                multilineSkip = 0;
                this.put(pos, packName, identifier, key, keyMetadata, PropertySeparator.EQUALS, builder.toString());
            }
        }
        return this;
    }
}

