/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.armor_visibility.client;

import com.diontryban.armor_visibility.ArmorVisibility;
import com.diontryban.armor_visibility.client.gui.screens.ArmorVisibilityOptionsScreen;
import com.diontryban.armor_visibility.options.ArmorVisibilityOptions;
import com.diontryban.ash_api.client.event.ClientTickEvent;
import com.diontryban.ash_api.client.gui.screens.ModOptionsScreenRegistry;
import com.diontryban.ash_api.client.input.KeyMappingRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class ArmorVisibilityClient {
    private static KeyMapping keyMapping;
    private static boolean keyWasDown;

    public static void init() {
        keyMapping = KeyMappingRegistry.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armor_visibility", (String)"armor_visibility_toggle"), (int)86, (String)"armor_visibility");
        ClientTickEvent.Pre.register(ArmorVisibilityClient::onClientStartTick);
        ModOptionsScreenRegistry.register(ArmorVisibility.OPTIONS, ArmorVisibilityOptionsScreen::new);
        ArmorVisibilityOptions options = (ArmorVisibilityOptions)ArmorVisibility.OPTIONS.get();
        if (!options.saveBetweenLaunches) {
            options.saveData.hideMyArmor = false;
            options.saveData.hideAllArmor = false;
        }
    }

    private static void onClientStartTick(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        ArmorVisibilityOptions options = (ArmorVisibilityOptions)ArmorVisibility.OPTIONS.get();
        if (keyMapping.isDown() && !keyWasDown) {
            if (options.saveData.hideAllArmor || options.saveData.hideMyArmor) {
                player.playSound(SoundEvents.TRIPWIRE_CLICK_OFF, 0.5f, 1.0f);
                options.saveData.hideMyArmor = false;
                options.saveData.hideAllArmor = false;
                ArmorVisibility.OPTIONS.write();
                player.displayClientMessage((Component)Component.translatable((String)"message.armor_visibility.show_armor"), true);
            } else {
                player.playSound(SoundEvents.TRIPWIRE_CLICK_ON, 0.5f, 1.0f);
                if (player.isShiftKeyDown()) {
                    options.saveData.hideAllArmor = true;
                    ArmorVisibility.OPTIONS.write();
                    player.displayClientMessage((Component)Component.translatable((String)"message.armor_visibility.hide_all_armor"), true);
                } else {
                    options.saveData.hideMyArmor = true;
                    ArmorVisibility.OPTIONS.write();
                    player.displayClientMessage((Component)Component.translatable((String)"message.armor_visibility.hide_my_armor"), true);
                }
            }
            keyWasDown = true;
        } else if (!keyMapping.isDown() && keyWasDown) {
            keyWasDown = false;
        }
    }

    public static boolean maybeCancelRender(LivingEntity livingEntity, CallbackInfo ci) {
        return ArmorVisibilityClient.maybeCancelRender(livingEntity, () -> ((CallbackInfo)ci).cancel());
    }

    public static boolean maybeCancelRender(LivingEntity livingEntity, Runnable onCancel) {
        ArmorVisibilityOptions options = (ArmorVisibilityOptions)ArmorVisibility.OPTIONS.get();
        if (options.playersOnly && !(livingEntity instanceof Player)) {
            return false;
        }
        if (options.saveData.hideAllArmor) {
            onCancel.run();
            return true;
        }
        if (options.saveData.hideMyArmor && livingEntity.equals((Object)Minecraft.getInstance().player)) {
            onCancel.run();
            return true;
        }
        return false;
    }

    static {
        keyWasDown = false;
    }
}

