/*
 * Decompiled with CFR 0.152.
 */
package einstein.armortrimitemfix;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmorTrimItemFix {
    public static final String MOD_ID = "armortrimitemfix";
    public static final String MOD_NAME = "ArmorTrimItemFix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ArmorTrimItemFix");
    public static final ResourceLocation TRIM_PATTERN_PREDICATE_ID = ArmorTrimItemFix.loc("trim_pattern");
    public static final float DEFAULT_TRIM_VALUE = 0.001f;
    public static final Map<Item, TrimmableData> TRIMMABLES = (Map)Util.make(new HashMap(), map -> {
        map.put(Items.LEATHER_HELMET, new TrimmableData("leather", ArmorItem.Type.HELMET));
        map.put(Items.LEATHER_CHESTPLATE, new TrimmableData("leather", ArmorItem.Type.CHESTPLATE));
        map.put(Items.LEATHER_LEGGINGS, new TrimmableData("leather", ArmorItem.Type.LEGGINGS));
        map.put(Items.LEATHER_BOOTS, new TrimmableData("leather", ArmorItem.Type.BOOTS));
        map.put(Items.CHAINMAIL_HELMET, new TrimmableData("chainmail", ArmorItem.Type.HELMET));
        map.put(Items.CHAINMAIL_CHESTPLATE, new TrimmableData("chainmail", ArmorItem.Type.CHESTPLATE));
        map.put(Items.CHAINMAIL_LEGGINGS, new TrimmableData("chainmail", ArmorItem.Type.LEGGINGS));
        map.put(Items.CHAINMAIL_BOOTS, new TrimmableData("chainmail", ArmorItem.Type.BOOTS));
        map.put(Items.IRON_HELMET, new TrimmableData("iron", ArmorItem.Type.HELMET));
        map.put(Items.IRON_CHESTPLATE, new TrimmableData("iron", ArmorItem.Type.CHESTPLATE));
        map.put(Items.IRON_LEGGINGS, new TrimmableData("iron", ArmorItem.Type.LEGGINGS));
        map.put(Items.IRON_BOOTS, new TrimmableData("iron", ArmorItem.Type.BOOTS));
        map.put(Items.GOLDEN_HELMET, new TrimmableData("golden", ArmorItem.Type.HELMET));
        map.put(Items.GOLDEN_CHESTPLATE, new TrimmableData("golden", ArmorItem.Type.CHESTPLATE));
        map.put(Items.GOLDEN_LEGGINGS, new TrimmableData("golden", ArmorItem.Type.LEGGINGS));
        map.put(Items.GOLDEN_BOOTS, new TrimmableData("golden", ArmorItem.Type.BOOTS));
        map.put(Items.DIAMOND_HELMET, new TrimmableData("diamond", ArmorItem.Type.HELMET));
        map.put(Items.DIAMOND_CHESTPLATE, new TrimmableData("diamond", ArmorItem.Type.CHESTPLATE));
        map.put(Items.DIAMOND_LEGGINGS, new TrimmableData("diamond", ArmorItem.Type.LEGGINGS));
        map.put(Items.DIAMOND_BOOTS, new TrimmableData("diamond", ArmorItem.Type.BOOTS));
        map.put(Items.NETHERITE_HELMET, new TrimmableData("netherite", ArmorItem.Type.HELMET));
        map.put(Items.NETHERITE_CHESTPLATE, new TrimmableData("netherite", ArmorItem.Type.CHESTPLATE));
        map.put(Items.NETHERITE_LEGGINGS, new TrimmableData("netherite", ArmorItem.Type.LEGGINGS));
        map.put(Items.NETHERITE_BOOTS, new TrimmableData("netherite", ArmorItem.Type.BOOTS));
        map.put(Items.TURTLE_HELMET, new TrimmableData("turtle", ArmorItem.Type.HELMET));
    });
    public static final TreeSet<MaterialData> TRIM_MATERIALS = (TreeSet)Util.make(new TreeSet(), list -> {
        list.add(new MaterialData("quartz", 0.1f));
        list.add(new MaterialData("iron", 0.2f, (Holder<ArmorMaterial>)ArmorMaterials.IRON, "iron_darker"));
        list.add(new MaterialData("netherite", 0.3f, (Holder<ArmorMaterial>)ArmorMaterials.NETHERITE, "netherite_darker"));
        list.add(new MaterialData("redstone", 0.4f));
        list.add(new MaterialData("copper", 0.5f));
        list.add(new MaterialData("gold", 0.6f, (Holder<ArmorMaterial>)ArmorMaterials.GOLD, "gold_darker"));
        list.add(new MaterialData("emerald", 0.7f));
        list.add(new MaterialData("diamond", 0.8f, (Holder<ArmorMaterial>)ArmorMaterials.DIAMOND, "diamond_darker"));
        list.add(new MaterialData("lapis", 0.9f));
        list.add(new MaterialData("amethyst", 1.0f));
    });
    public static final Map<ResourceLocation, Float> TRIM_PATTERNS = ArmorTrimItemFix.createValueSortedMap((Map)Util.make(new HashMap(), map -> {
        List locations = (List)Util.make(new ArrayList(), list -> {
            list.add(TrimPatterns.SENTRY.location());
            list.add(TrimPatterns.DUNE.location());
            list.add(TrimPatterns.COAST.location());
            list.add(TrimPatterns.WILD.location());
            list.add(TrimPatterns.WARD.location());
            list.add(TrimPatterns.EYE.location());
            list.add(TrimPatterns.VEX.location());
            list.add(TrimPatterns.TIDE.location());
            list.add(TrimPatterns.SNOUT.location());
            list.add(TrimPatterns.RIB.location());
            list.add(TrimPatterns.SPIRE.location());
            list.add(TrimPatterns.WAYFINDER.location());
            list.add(TrimPatterns.SHAPER.location());
            list.add(TrimPatterns.SILENCE.location());
            list.add(TrimPatterns.RAISER.location());
            list.add(TrimPatterns.HOST.location());
            list.add(TrimPatterns.FLOW.location());
            list.add(TrimPatterns.BOLT.location());
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("storm"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("ram"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("myth"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("greed"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("beast"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("fever"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("wraith"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("nihility"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("horizon"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("origin"));
        });
        float f = 0.0f;
        float f1 = 1.0f / (float)(locations.size() + 1);
        for (ResourceLocation location : locations) {
            map.put(location, Float.valueOf(f += f1));
        }
    }), Float::compare);

    public static void init() {
    }

    public static void clientSetup() {
        for (Item trimmable : TRIMMABLES.keySet()) {
            ArmorTrimItemFix.registerArmorTrimProperty(trimmable);
        }
    }

    public static void registerArmorTrimProperty(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)TRIM_PATTERN_PREDICATE_ID, (stack, level, entity, seed) -> {
            ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
            if (trim != null) {
                return TRIM_PATTERNS.getOrDefault(((ResourceKey)trim.pattern().unwrapKey().orElseThrow()).location(), Float.valueOf(0.001f)).floatValue();
            }
            return 0.0f;
        });
    }

    public static void registerDevCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"spawnArmorTrimItemFrames").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayerOrException();
            Level level = player.level();
            RegistryAccess registryAccess = level.registryAccess();
            Registry materialRegistry = registryAccess.registryOrThrow(Registries.TRIM_MATERIAL);
            Registry patternRegistry = registryAccess.registryOrThrow(Registries.TRIM_PATTERN);
            BlockPos playerPos = player.blockPosition();
            BlockPos.MutableBlockPos pos = playerPos.mutable();
            int[] zOffset = new int[]{pos.getZ()};
            TRIMMABLES.forEach((item, type) -> {
                if (pos.getX() - playerPos.getX() > (materialRegistry.size() + 1) * 4) {
                    zOffset[0] = pos.getZ() + patternRegistry.size() + 1;
                    pos.setX(playerPos.getX());
                    pos.setZ(zOffset[0]);
                }
                materialRegistry.forEach(material -> {
                    pos.setX(pos.getX() + 1);
                    patternRegistry.forEach(pattern -> {
                        ItemFrame itemFrame = new ItemFrame(level, level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos.setZ(pos.getZ() + 1)), Direction.UP);
                        ItemStack stack = new ItemStack((ItemLike)item);
                        stack.set(DataComponents.TRIM, (Object)new ArmorTrim(materialRegistry.wrapAsHolder(material), patternRegistry.wrapAsHolder(pattern)));
                        itemFrame.setItem(stack);
                        level.addFreshEntity((Entity)itemFrame);
                    });
                    pos.setZ(zOffset[0]);
                });
                pos.setX(pos.getX() + 1);
            });
            source.sendSuccess(() -> Component.literal((String)"Spawned item frames with armor trims"), true);
            return 1;
        }));
    }

    public static ResourceLocation overrideName(TrimmableData data, ResourceLocation item, String patternName, String materialName) {
        return ArmorTrimItemFix.loc("item/" + data.armorMaterial() + "/" + data.type().getName() + "/" + item.getPath() + "_" + patternName + "_" + materialName + "_trim");
    }

    public static ResourceLocation vanillaOverrideName(ResourceLocation item, String materialName) {
        return ResourceLocation.withDefaultNamespace((String)(item.getPath() + "_" + materialName + "_trim"));
    }

    public static ResourceLocation layerLoc(ArmorItem.Type armorType, String patternName, String materialName) {
        return ArmorTrimItemFix.loc("trims/items/" + armorType.getName() + "/" + armorType.getName() + "_" + patternName + "_trim_" + materialName);
    }

    public static boolean isDoubleLayered(Item item) {
        return item == Items.LEATHER_HELMET || item == Items.LEATHER_CHESTPLATE || item == Items.LEATHER_LEGGINGS || item == Items.LEATHER_BOOTS;
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private static ResourceLocation moreArmorTrimsLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"more_armor_trims", (String)path);
    }

    public static <K, V> Map<K, V> createValueSortedMap(Map<K, V> map, Comparator<V> comparator) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public record TrimmableData(String armorMaterial, ArmorItem.Type type) {
    }

    public record MaterialData(String materialName, float propertyValue, Holder<ArmorMaterial> armorMaterial, String overrideName) implements Comparable<MaterialData>
    {
        public MaterialData(String materialName, float propertyValue) {
            this(materialName, propertyValue, null, null);
        }

        public String getName(Item item) {
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (this.armorMaterial != null && this.overrideName != null && armorItem.getMaterial().is((ResourceKey)this.armorMaterial.unwrapKey().orElseThrow())) {
                    return this.overrideName;
                }
            }
            return this.materialName;
        }

        @Override
        public int compareTo(@NotNull MaterialData o) {
            return Float.compare(this.propertyValue(), o.propertyValue());
        }
    }
}

