/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.caffeinemc.mods.sodium.client.gl.GlObject;
import net.caffeinemc.mods.sodium.client.gl.shader.GlShader;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniform;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformBlock;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL32C;

public class GlProgram<T>
extends GlObject
implements ShaderBindingContext {
    private static final Logger LOGGER = LogManager.getLogger(GlProgram.class);
    private final T shaderInterface;

    protected GlProgram(int program, Function<ShaderBindingContext, T> interfaceFactory) {
        this.setHandle(program);
        this.shaderInterface = interfaceFactory.apply(this);
    }

    public T getInterface() {
        return this.shaderInterface;
    }

    public static Builder builder(ResourceLocation name) {
        return new Builder(name);
    }

    public void bind() {
        GL20C.glUseProgram((int)this.handle());
    }

    public void unbind() {
        GL20C.glUseProgram((int)0);
    }

    public void delete() {
        GL20C.glDeleteProgram((int)this.handle());
        this.invalidateHandle();
    }

    @Override
    @NotNull
    public <U extends GlUniform<?>> U bindUniform(String name, IntFunction<U> factory) {
        int index = GL20C.glGetUniformLocation((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No uniform exists with name: " + name);
        }
        return (U)((GlUniform)factory.apply(index));
    }

    @Override
    public <U extends GlUniform<?>> U bindUniformOptional(String name, IntFunction<U> factory) {
        int index = GL20C.glGetUniformLocation((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            return null;
        }
        return (U)((GlUniform)factory.apply(index));
    }

    @Override
    @NotNull
    public GlUniformBlock bindUniformBlock(String name, int bindingPoint) {
        int index = GL32C.glGetUniformBlockIndex((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No uniform block exists with name: " + name);
        }
        GL32C.glUniformBlockBinding((int)this.handle(), (int)index, (int)bindingPoint);
        return new GlUniformBlock(bindingPoint);
    }

    @Override
    public GlUniformBlock bindUniformBlockOptional(String name, int bindingPoint) {
        int index = GL32C.glGetUniformBlockIndex((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            return null;
        }
        GL32C.glUniformBlockBinding((int)this.handle(), (int)index, (int)bindingPoint);
        return new GlUniformBlock(bindingPoint);
    }

    public static class Builder {
        private final ResourceLocation name;
        private final int program;

        public Builder(ResourceLocation name) {
            this.name = name;
            this.program = GL20C.glCreateProgram();
        }

        public Builder attachShader(GlShader shader) {
            GL20C.glAttachShader((int)this.program, (int)shader.handle());
            return this;
        }

        public <U> GlProgram<U> link(Function<ShaderBindingContext, U> factory) {
            int result;
            GL20C.glLinkProgram((int)this.program);
            String log = GL20C.glGetProgramInfoLog((int)this.program);
            if (!log.isEmpty()) {
                LOGGER.warn("Program link log for " + String.valueOf(this.name) + ": " + log);
            }
            if ((result = GlStateManager.glGetProgrami((int)this.program, (int)35714)) != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
            return new GlProgram<U>(this.program, factory);
        }

        public Builder bindAttribute(String name, int index) {
            GL20C.glBindAttribLocation((int)this.program, (int)index, (CharSequence)name);
            return this;
        }

        public Builder bindFragmentData(String name, int index) {
            GL30C.glBindFragDataLocation((int)this.program, (int)index, (CharSequence)name);
            return this;
        }
    }
}

