/*
 * Decompiled with CFR 0.152.
 */
package com.samgj15.nightlights.blocks;

import com.samgj15.nightlights.blocks.AbstractLightBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NightLightBlock
extends AbstractLightBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    private static final int[] BRIGHTNESS_LEVELS = new int[]{0, 8, 13};

    public NightLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BRIGHTNESS, (Comparable)Integer.valueOf(this.getDefaultBrightness())));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        return NightLightBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)below) || NightLightBlock.canSupportCenter((LevelReader)level, (BlockPos)below, (Direction)Direction.UP);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BRIGHTNESS, (Comparable)Integer.valueOf(this.getDefaultBrightness()))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, FACING, BRIGHTNESS});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected int getDefaultBrightness() {
        return 8;
    }

    @Override
    protected boolean isAdjustable() {
        return true;
    }

    @Override
    protected int[] getBrightnessLevels() {
        return BRIGHTNESS_LEVELS;
    }
}

