/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.gui.AdvancedImageButton;
import com.aizistral.nochatreports.common.gui.EncryptionConfigScreen;
import com.aizistral.nochatreports.common.gui.EncryptionWarningScreen;
import com.aizistral.nochatreports.common.gui.GUIShenanigans;
import com.aizistral.nochatreports.common.gui.SwitchableSprites;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class EncryptionButton
extends AdvancedImageButton {
    public EncryptionButton(int x, int y, int xSize, int ySize, int useSprites, Button.OnPress onPress, Component name, Screen parent) {
        super(x, y, xSize, ySize, EncryptionButton.getSprites(useSprites), onPress, name, parent);
    }

    public boolean mouseClicked(double x, double y, int i) {
        if (!this.active || !this.visible) {
            return false;
        }
        if (i == 1 && this.clicked(x, y)) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.openEncryptionConfig();
            return true;
        }
        return super.mouseClicked(x, y, i);
    }

    public void openEncryptionConfig() {
        if (!(EncryptionWarningScreen.seenOnThisSession() || NCRConfig.getEncryption().isWarningDisabled() || NCRConfig.getEncryption().isEnabledAndValid())) {
            Minecraft.getInstance().setScreen((Screen)new EncryptionWarningScreen(this.parent));
        } else {
            Minecraft.getInstance().setScreen((Screen)new EncryptionConfigScreen(this.parent));
        }
    }

    private static SwitchableSprites getSprites(int useIndex) {
        SwitchableSprites sprites = SwitchableSprites.of(GUIShenanigans.getSprites("encryption/active_button"), GUIShenanigans.getSprites("encryption/inactive_button"), GUIShenanigans.getSprites("encryption/error_button"));
        sprites.setIndex(useIndex);
        return sprites;
    }
}

