/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.config.ServerConfig;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.utils.TubeUtils;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class HyperEntranceBlockEntity
extends ActionTubeBlockEntity
implements IHaveHoveringInformation {
    private IConnection connection;

    public HyperEntranceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (compound.contains("Connection")) {
            this.connection = this.getConnectionRelative(compound, "Connection", this.worldPosition);
        }
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.writeConnectionRelative(compound, this.worldPosition, new Tuple[]{new Tuple((Object)this.connection, (Object)"Connection")});
    }

    @Override
    public boolean wrenchClicked(Direction direction) {
        IConnection connectionInDirection = this.getConnectionInDirection(direction);
        if (connectionInDirection == null) {
            return false;
        }
        connectionInDirection.updateTubeSegments(this.level);
        return true;
    }

    public void tick() {
        boolean canOpen;
        super.tick();
        Boolean isBlocked = (Boolean)this.getBlockState().getValue((Property)HyperEntranceBlock.IN_FRONT);
        if (this.level.isClientSide) {
            this.tickClient(isBlocked);
            return;
        }
        if (isBlocked.booleanValue()) {
            return;
        }
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        float actualSpeed = Math.abs(this.getSpeed());
        Boolean isOpen = (Boolean)state.getValue((Property)HyperEntranceBlock.OPEN);
        if (actualSpeed < 16.0f) {
            if (isOpen.booleanValue()) {
                this.level.setBlock(pos, (BlockState)state.setValue((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playOpenCloseSound(false);
            }
            return;
        }
        boolean isNotLocked = (Boolean)this.getBlockState().getValue((Property)HyperEntranceBlock.LOCKED) == false;
        LivingEntity nearbyEntity = this.getNearbyLivingEntities((ServerLevel)this.level, pos.getCenter());
        boolean bl = canOpen = nearbyEntity != null && (isNotLocked || nearbyEntity.isShiftKeyDown() || nearbyEntity.getPersistentData().getBoolean("hypertube_travel"));
        if (this.isTubeClosed(canOpen, isOpen)) {
            return;
        }
        LivingEntity inRangeEntity = this.getInRangeLivingEntities((ServerLevel)this.level, pos.getCenter(), (Direction)state.getValue((Property)HyperEntranceBlock.FACING));
        if (inRangeEntity == null) {
            return;
        }
        if (isNotLocked && inRangeEntity.isShiftKeyDown() && !inRangeEntity.getPersistentData().getBoolean("hypertube_travel")) {
            return;
        }
        TravelManager.tryStartTravel(inRangeEntity, pos, state, TubeUtils.calculateTravelSpeed(actualSpeed));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient(boolean isBlocked) {
        float actualSpeed = Math.abs(this.getSpeed());
        TubeSoundManager.TubeAmbientSound sound = TubeSoundManager.getAmbientSound(this.tubeSoundId);
        if (actualSpeed < 16.0f || isBlocked) {
            sound.tickClientPlayerSounds();
            return;
        }
        this.playClientEffects(sound);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float finalSpeed = Math.abs(this.getSpeed());
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (finalSpeed < 16.0f ? 1 : 0) != 0).forGoggles(tooltip);
        if (((Boolean)this.getBlockState().getValue((Property)HyperEntranceBlock.IN_FRONT)).booleanValue()) {
            tooltip.add((Component)Component.literal((String)"     ").append((Component)Component.translatable((String)"tooltip.create_hypertube.entrance_blocked").withColor(0xFF0000)));
        } else if (finalSpeed < 16.0f) {
            tooltip.add((Component)Component.literal((String)"     ").append((Component)Component.literal((String)"\u2592 ")).append((Component)Component.translatable((String)"tooltip.create_hypertube.entrance_no_speed")).withColor(0xFF0000));
        }
        return true;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (((Boolean)this.getBlockState().getValue((Property)HyperEntranceBlock.LOCKED)).booleanValue() && Math.abs(this.getSpeed()) >= 16.0f) {
            tooltip.add((Component)Component.literal((String)"     ").append((Component)Component.translatable((String)"block.hypertube.hyper_entrance.sneak_to_enter")).withColor(0xFFFFFF));
        }
        return true;
    }

    @Override
    public void setConnection(IConnection connection, Direction thisConnectionDir) {
        if (this.connection != null) {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not define connection", this.connection, connection).getMessage());
            return;
        }
        this.connection = connection;
        this.setChanged();
        this.sync();
    }

    @Override
    public void clearConnection(IConnection connection) {
        if (this.connection == null || !this.connection.isSameConnection(connection)) {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not be cleared", this.connection, connection).getMessage());
            return;
        }
        this.connection = null;
        this.setChanged();
        this.sync();
    }

    @Override
    public List<Direction> getFacesConnectable() {
        if (this.connection != null) {
            return List.of();
        }
        return List.of((Direction)this.getBlockState().getValue((Property)HyperEntranceBlock.FACING));
    }

    @Override
    public List<IConnection> getConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        if (this.connection != null) {
            connections.add(this.connection);
        }
        return connections;
    }

    @Override
    public Vec3 getExitDirection() {
        if (this.getBlockState().hasProperty((Property)HyperEntranceBlock.FACING)) {
            Direction facing = ((Direction)this.getBlockState().getValue((Property)HyperEntranceBlock.FACING)).getOpposite();
            return Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
        }
        return null;
    }

    @Override
    protected int getConnectionCount() {
        return 1;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)ServerConfig.get().STRESS_IMPACT_ENTRANCE.getAsDouble();
        return impact;
    }

    public IConnection getConnection() {
        return this.connection;
    }
}

