/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.TubeBlockEntity;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class HypertubeBlockEntity
extends TubeBlockEntity {
    private IConnection connectionOne;
    private IConnection connectionTwo;

    public HypertubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (compound.contains("ConnectionTo")) {
            this.connectionOne = this.getConnectionRelative(compound, "ConnectionTo", this.worldPosition);
        }
        if (compound.contains("ConnectionFrom")) {
            this.connectionTwo = this.getConnectionRelative(compound, "ConnectionFrom", this.worldPosition);
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.writeConnectionRelative(compound, this.worldPosition, new Tuple[]{new Tuple((Object)this.connectionOne, (Object)"ConnectionTo"), new Tuple((Object)this.connectionTwo, (Object)"ConnectionFrom")});
    }

    @Override
    public boolean wrenchClicked(Direction direction) {
        IConnection connectionInDirection = this.getConnectionInDirection(direction);
        if (connectionInDirection == null) {
            if (this.connectionOne != null) {
                this.connectionOne.updateTubeSegments(this.level);
            }
            if (this.connectionTwo != null) {
                this.connectionTwo.updateTubeSegments(this.level);
            }
            return true;
        }
        connectionInDirection.updateTubeSegments(this.level);
        return true;
    }

    @Override
    public List<IConnection> getConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        if (this.connectionOne != null) {
            connections.add(this.connectionOne);
        }
        if (this.connectionTwo != null) {
            connections.add(this.connectionTwo);
        }
        return connections;
    }

    @Override
    public void setConnection(IConnection connection, Direction thisConnectionDir) {
        BlockState blockState;
        Block block;
        if (this.connectionOne == null) {
            this.connectionOne = connection;
        } else if (this.connectionTwo == null) {
            this.connectionTwo = connection;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not define connection", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        if (this.level != null && !this.level.isClientSide() && (block = (blockState = this.level.getBlockState(this.worldPosition)).getBlock()) instanceof HypertubeBlock) {
            HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
            hypertubeBlock.updateBlockStateFromEntity(blockState, this.level, this.worldPosition);
            if (thisConnectionDir != null) {
                BlockState state = hypertubeBlock.getState(blockState, List.of(thisConnectionDir), true);
                hypertubeBlock.updateBlockState(this.level, this.worldPosition, state);
            }
        }
        this.setChanged();
        this.sync();
    }

    @Override
    public void clearConnection(IConnection connection) {
        BlockState blockState;
        Block block;
        if (this.connectionOne != null && this.connectionOne.isSameConnection(connection)) {
            this.connectionOne = null;
        } else if (this.connectionTwo != null && this.connectionTwo.isSameConnection(connection)) {
            this.connectionTwo = null;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not be cleared", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        if (this.level != null && !this.level.isClientSide() && (block = (blockState = this.level.getBlockState(this.worldPosition)).getBlock()) instanceof HypertubeBlock) {
            HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
            hypertubeBlock.updateBlockStateFromEntity(blockState, this.level, this.worldPosition);
        }
        this.setChanged();
        this.sync();
    }

    @Override
    protected int getConnectionCount() {
        return 2;
    }

    public IConnection getConnectionOne() {
        return this.connectionOne;
    }

    public IConnection getConnectionTwo() {
        return this.connectionTwo;
    }
}

