/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class TubeBlockEntity
extends KineticBlockEntity
implements ITubeConnectionEntity {
    public TubeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected abstract int getConnectionCount();

    public void sync() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean getConnectionDirection(Direction direction, IConnection connection) {
        SimpleConnection sameConnectionBlockPos;
        if (connection != null && (sameConnectionBlockPos = IConnection.getSameConnectionBlockPos(connection, this.level, this.worldPosition)) != null) {
            Direction thisConn = sameConnectionBlockPos.direction();
            return thisConn != null && thisConn.equals((Object)direction);
        }
        return false;
    }

    @Override
    public List<Direction> getFacesConnectable() {
        List connections = this.getConnections();
        if (connections.size() >= this.getConnectionCount()) {
            return List.of();
        }
        List<Direction> possibleDirections = ((ITubeConnection)this.getBlockState().getBlock()).getConnectedFaces(this.getBlockState());
        if (possibleDirections.isEmpty()) {
            return List.of(Direction.values());
        }
        possibleDirections.removeIf(direction -> {
            Iterator iterator = connections.iterator();
            if (iterator.hasNext()) {
                IConnection connection = (IConnection)iterator.next();
                return this.getConnectionDirection((Direction)direction, connection);
            }
            return false;
        });
        return possibleDirections;
    }

    @Override
    @Nullable
    public IConnection getConnectionInDirection(Direction direction) {
        List connections = this.getConnections();
        if (connections.isEmpty()) {
            return null;
        }
        for (IConnection connection : connections) {
            if (!this.getConnectionDirection(direction, connection)) continue;
            return connection;
        }
        return null;
    }

    @Override
    @Nullable
    public IConnection getThisConnectionFrom(SimpleConnection connection) {
        List connections = this.getConnections();
        if (connections.isEmpty()) {
            return null;
        }
        for (IConnection conn : connections) {
            BezierConnection bezierConn;
            if (!(conn instanceof BezierConnection) || !connection.isSameConnection((bezierConn = (BezierConnection)conn).getFromPos())) continue;
            return conn;
        }
        return null;
    }

    @Override
    public boolean hasConnectionAvailable() {
        List connections = this.getConnections();
        if (connections.isEmpty()) {
            return true;
        }
        return connections.size() < this.getConnectionCount();
    }

    @Override
    public boolean isConnected() {
        List connections = this.getConnections();
        return !connections.isEmpty();
    }

    @Override
    public int blockBroken() {
        int toDrop = 0;
        List connections = this.getConnections();
        if (connections.isEmpty()) {
            return toDrop;
        }
        for (IConnection connection : connections) {
            toDrop += this.blockBroken(this.level, connection, this.worldPosition);
        }
        return toDrop;
    }

    @Override
    public Vec3 getExitDirection() {
        List connections = this.getConnections();
        if (connections.isEmpty()) {
            return null;
        }
        IConnection first = (IConnection)connections.get(0);
        SimpleConnection sameConnectionBlockPos = IConnection.getSameConnectionBlockPos(first, this.level, this.getBlockPos());
        if (sameConnectionBlockPos == null) {
            return null;
        }
        return Vec3.atLowerCornerOf((Vec3i)sameConnectionBlockPos.direction().getOpposite().getNormal());
    }
}

