/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.connection;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.placement.ResponseDTO;
import com.pedrorok.hypertube.utils.CodecUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BezierConnection
implements IConnection {
    public static final Codec<BezierConnection> CODEC = RecordCodecBuilder.create(i -> i.group((App)SimpleConnection.CODEC.fieldOf("fromPos").forGetter(BezierConnection::getFromPos), (App)SimpleConnection.CODEC.fieldOf("toPos").forGetter(BezierConnection::getToPos), (App)Codec.INT.fieldOf("tubeSegments").forGetter(BezierConnection::getTubeSegments), (App)Vec3.CODEC.listOf().fieldOf("curvePoints").forGetter(BezierConnection::getCachedRelativeBezierPoints)).apply((Applicative)i, BezierConnection::new));
    public static final StreamCodec<ByteBuf, BezierConnection> STREAM_CODEC = StreamCodec.composite(SimpleConnection.STREAM_CODEC, BezierConnection::getFromPos, SimpleConnection.STREAM_CODEC, BezierConnection::getToPos, CodecUtils.INTEGER, BezierConnection::getTubeSegments, CodecUtils.VEC3_LIST, BezierConnection::getCachedRelativeBezierPoints, BezierConnection::new);
    private static final float MAX_REASONABLE_DISTANCE = 1000.0f;
    public static final float MAX_DISTANCE = 40.0f;
    public static final float MAX_ANGLE = 0.6f;
    private final UUID uuid = UUID.randomUUID();
    private final SimpleConnection fromPos;
    @Nullable
    private SimpleConnection toPos;
    private int tubeSegments;
    private final List<Vec3> cachedRelativeBezierPoints;
    private ResponseDTO valid;
    private final int detailLevel;

    public BezierConnection(SimpleConnection fromPos, SimpleConnection toPos, int tubeSegments, List<Vec3> cachedPoints) {
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.tubeSegments = tubeSegments;
        this.detailLevel = toPos != null ? (int)Math.max(3.0, fromPos.pos().getCenter().distanceTo(toPos.pos().getCenter())) : 0;
        this.cachedRelativeBezierPoints = cachedPoints != null ? cachedPoints : this.calculateRelativeBezierPoints();
    }

    public BezierConnection(SimpleConnection fromPos, @Nullable SimpleConnection toPos) {
        this(fromPos, toPos, 1, toPos != null ? (int)Math.max(3.0, fromPos.pos().getCenter().distanceTo(toPos.pos().getCenter())) : 0);
    }

    public BezierConnection(SimpleConnection fromPos, @Nullable SimpleConnection toPos, int tubeSegments, int detailLevel) {
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.detailLevel = detailLevel;
        this.tubeSegments = tubeSegments;
        this.cachedRelativeBezierPoints = this.calculateRelativeBezierPoints();
    }

    private List<Vec3> calculateRelativeBezierPoints() {
        if (this.toPos == null) {
            return List.of();
        }
        BlockPos storedFromPos = this.fromPos.pos();
        BlockPos storedToPos = this.toPos.pos();
        BlockPos offset = storedToPos.subtract((Vec3i)storedFromPos);
        Vec3 fromRelative = new Vec3(0.5, 0.5, 0.5);
        Vec3 toRelative = new Vec3((double)offset.getX() + 0.5, (double)offset.getY() + 0.5, (double)offset.getZ() + 0.5);
        double distance = fromRelative.distanceTo(toRelative);
        Vec3 controlPoint1 = this.createFirstControlPoint(fromRelative, this.fromPos.direction(), distance);
        Vec3 controlPoint2 = this.createSecondControlPoint(toRelative, this.fromPos.direction(), distance, this.toPos.direction() != null ? Vec3.atLowerCornerOf((Vec3i)this.toPos.direction().getNormal()) : null);
        ArrayList<Vec3> curvePoints = new ArrayList<Vec3>();
        for (int i = 0; i <= this.detailLevel; ++i) {
            double t = (double)i / (double)this.detailLevel;
            Vec3 point = this.cubicBezier(fromRelative, controlPoint1, controlPoint2, toRelative, t);
            curvePoints.add(point);
        }
        return curvePoints;
    }

    @Deprecated
    public List<Vec3> getBezierPoints() {
        if (this.cachedRelativeBezierPoints.isEmpty()) {
            return List.of();
        }
        Vec3 originAbsolute = Vec3.atLowerCornerOf((Vec3i)this.fromPos.pos());
        ArrayList<Vec3> absolutePoints = new ArrayList<Vec3>(this.cachedRelativeBezierPoints.size());
        for (Vec3 relativePoint : this.cachedRelativeBezierPoints) {
            absolutePoints.add(originAbsolute.add(relativePoint));
        }
        return absolutePoints;
    }

    public List<Vec3> getBezierPoints(Level level, BlockPos currentFromPos) {
        if (this.cachedRelativeBezierPoints.isEmpty()) {
            return List.of();
        }
        Vec3 originAbsolute = Vec3.atLowerCornerOf((Vec3i)currentFromPos);
        ArrayList<Vec3> absolutePoints = new ArrayList<Vec3>(this.cachedRelativeBezierPoints.size());
        for (Vec3 relativePoint : this.cachedRelativeBezierPoints) {
            absolutePoints.add(originAbsolute.add(relativePoint));
        }
        return absolutePoints;
    }

    public List<Vec3> getRelativeBezierPoints(BlockPos originPos) {
        if (this.cachedRelativeBezierPoints.isEmpty()) {
            return List.of();
        }
        if (originPos.equals((Object)this.fromPos.pos())) {
            return new ArrayList<Vec3>(this.cachedRelativeBezierPoints);
        }
        BlockPos offset = this.fromPos.pos().subtract((Vec3i)originPos);
        Vec3 offsetVec = new Vec3((double)offset.getX(), (double)offset.getY(), (double)offset.getZ());
        ArrayList<Vec3> adjustedPoints = new ArrayList<Vec3>(this.cachedRelativeBezierPoints.size());
        for (Vec3 point : this.cachedRelativeBezierPoints) {
            adjustedPoints.add(point.add(offsetVec));
        }
        return adjustedPoints;
    }

    public List<Vec3> getRelativeBezierPoints(Level level, BlockPos originPos) {
        return new ArrayList<Vec3>(this.cachedRelativeBezierPoints);
    }

    private Vec3 createFirstControlPoint(Vec3 from, Direction direction, double distance) {
        double controlDistance = distance * 0.4;
        return from.add((double)direction.getStepX() * controlDistance, (double)direction.getStepY() * controlDistance, (double)direction.getStepZ() * controlDistance);
    }

    private Vec3 createSecondControlPoint(Vec3 to, Direction fromDirection, double distance, @Nullable Vec3 finalDirection) {
        if (finalDirection != null) {
            double controlDistance = distance * 0.4;
            return to.subtract(finalDirection.x * controlDistance, finalDirection.y * controlDistance, finalDirection.z * controlDistance);
        }
        Direction oppositeDirection = fromDirection.getOpposite();
        double controlDistance = distance * 0.4;
        return to.add((double)oppositeDirection.getStepX() * controlDistance, (double)oppositeDirection.getStepY() * controlDistance, (double)oppositeDirection.getStepZ() * controlDistance);
    }

    private Vec3 cubicBezier(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, double t) {
        double oneMinusT = 1.0 - t;
        double oneMinusTCubed = oneMinusT * oneMinusT * oneMinusT;
        double oneMinusTSquared = oneMinusT * oneMinusT;
        double tSquared = t * t;
        double tCubed = tSquared * t;
        double x = oneMinusTCubed * p0.x + 3.0 * oneMinusTSquared * t * p1.x + 3.0 * oneMinusT * tSquared * p2.x + tCubed * p3.x;
        double y = oneMinusTCubed * p0.y + 3.0 * oneMinusTSquared * t * p1.y + 3.0 * oneMinusT * tSquared * p2.y + tCubed * p3.y;
        double z = oneMinusTCubed * p0.z + 3.0 * oneMinusTSquared * t * p1.z + 3.0 * oneMinusT * tSquared * p2.z + tCubed * p3.z;
        return new Vec3(x, y, z);
    }

    public float getMaxAngleBezierAngle() {
        Vec3 secondDirection;
        List<Vec3> points = this.getBezierPoints();
        if (this.distance() > 1000.0f) {
            return 0.0f;
        }
        Vec3 first = points.getFirst();
        Vec3 second = points.get(1);
        Direction direction = this.fromPos.direction();
        Vec3 firstDirection = new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ());
        float initialAngle = (float)Math.acos(firstDirection.dot(secondDirection = second.subtract(first).normalize()) / (firstDirection.length() * secondDirection.length()));
        if ((double)initialAngle >= 2.0) {
            return initialAngle;
        }
        return this.getMaxAngle(points);
    }

    private float getMaxAngle(List<Vec3> points) {
        float maxAngle = 0.0f;
        Vec3 lastPoint = points.getFirst();
        for (int i = 1; i < points.size() - 1; ++i) {
            Vec3 currentPoint = points.get(i);
            Vec3 nextPoint = points.get(i + 1);
            Vec3 vector1 = currentPoint.subtract(lastPoint);
            Vec3 vector2 = nextPoint.subtract(currentPoint);
            float angle = (float)Math.acos(vector1.dot(vector2) / (vector1.length() * vector2.length()));
            maxAngle = Math.max(maxAngle, angle);
            lastPoint = currentPoint;
        }
        return maxAngle;
    }

    public float distance() {
        if (this.toPos == null) {
            return 0.0f;
        }
        return (float)this.fromPos.pos().getCenter().distanceTo(this.toPos.pos().getCenter());
    }

    public ResponseDTO getValidation() {
        if (this.valid != null) {
            return this.valid;
        }
        if (this.fromPos == null || this.toPos == null) {
            this.valid = ResponseDTO.invalid("placement.create_hypertube.no_valid_points");
            return this.valid;
        }
        if (this.getMaxAngleBezierAngle() >= 0.6f) {
            this.valid = ResponseDTO.invalid("placement.create_hypertube.angle_too_high");
            return this.valid;
        }
        if (this.distance() >= 40.0f) {
            this.valid = ResponseDTO.invalid("placement.create_hypertube.distance_too_high");
            return this.valid;
        }
        if (this.distance() <= 1.0f) {
            this.valid = ResponseDTO.invalid();
            return this.valid;
        }
        return ResponseDTO.get(true);
    }

    public static BezierConnection of(SimpleConnection from, @Nullable SimpleConnection toPos) {
        return new BezierConnection(from, toPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPath(LerpedFloat animation, boolean isValid) {
        if (this.distance() > 1000.0f) {
            return;
        }
        Vec3 pos1 = this.fromPos.pos().getCenter();
        int id = 0;
        for (Vec3 bezierPoint : this.getBezierPoints()) {
            BezierConnection.line(this.uuid, id, pos1, bezierPoint, animation, !isValid);
            pos1 = bezierPoint;
            ++id;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void line(UUID uuid, int id, Vec3 start, Vec3 end, LerpedFloat animation, boolean hasException) {
        int color = Color.mixColors((int)15359019, (int)9817409, (float)animation.getValue());
        if (hasException) {
            Vec3 diff = end.subtract(start);
            start = start.add(diff.scale(0.2));
            end = start.add(diff.scale(-0.2));
        }
        Outliner.getInstance().showLine((Object)Pair.of((Object)uuid, (Object)id), start, end).lineWidth(0.125f).disableLineNormals().colored(color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void outlineBlocks(BlockPos pos) {
        Outliner.getInstance().showAABB((Object)pos.asLong(), new AABB((double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).colored(15359019).lineWidth(0.125f).disableLineNormals();
    }

    public BezierConnection invert() {
        return new BezierConnection(new SimpleConnection(this.toPos.pos(), this.toPos.direction().getOpposite()), new SimpleConnection(this.fromPos.pos(), this.fromPos.direction().getOpposite()), this.tubeSegments, this.detailLevel);
    }

    @Override
    public BezierConnection getThisEntranceConnection(Level level) {
        return this;
    }

    @Override
    public Direction getThisEntranceDirection(Level level) {
        return this.fromPos.direction();
    }

    @Override
    public boolean isSameConnection(IConnection connection) {
        return this.fromPos.isSameConnection(connection) || connection.equals(this);
    }

    @Override
    public SimpleConnection getThisConnection() {
        return this.getFromPos();
    }

    @Override
    public void updateTubeSegments(Level level) {
        this.tubeSegments = this.tubeSegments == 1 ? 2 : 1;
        BlockState state = level.getBlockState(this.fromPos.pos());
        level.updateNeighborsAt(this.fromPos.pos(), state.getBlock());
        level.sendBlockUpdated(this.fromPos.pos(), state, state, 3);
    }

    public String toString() {
        return "BezierConnection{fromPos=" + String.valueOf(this.fromPos) + ", toPos=" + String.valueOf(this.toPos) + ", isValid=" + String.valueOf(this.valid) + "}";
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public SimpleConnection getFromPos() {
        return this.fromPos;
    }

    @Nullable
    public SimpleConnection getToPos() {
        return this.toPos;
    }

    public int getTubeSegments() {
        return this.tubeSegments;
    }

    public List<Vec3> getCachedRelativeBezierPoints() {
        return this.cachedRelativeBezierPoints;
    }
}

