/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.connection.interfaces;

import com.mojang.serialization.DynamicOps;
import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface ITubeConnectionEntity {
    default public IConnection getConnection(CompoundTag tag, String key) {
        try {
            return (IConnection)BezierConnection.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(key)).getOrThrow();
        }
        catch (Exception ignored) {
            return (IConnection)SimpleConnection.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(key)).getOrThrow();
        }
    }

    default public void writeConnection(CompoundTag tag, Tuple<IConnection, String> ... connections) {
        for (Tuple<IConnection, String> connection : connections) {
            this.writeConnection(tag, (IConnection)connection.getA(), (String)connection.getB());
        }
    }

    private void writeConnection(CompoundTag tag, IConnection connection, String key) {
        if (connection instanceof SimpleConnection) {
            SimpleConnection simpleConnection = (SimpleConnection)connection;
            tag.put(key, (Tag)SimpleConnection.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)simpleConnection).getOrThrow());
        } else {
            tag.put(key, (Tag)BezierConnection.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((BezierConnection)connection)).getOrThrow());
        }
    }

    default public IConnection getConnectionRelative(CompoundTag tag, String key, BlockPos referencePos) {
        boolean isNewFormat = tag.contains(key + "_version");
        try {
            BezierConnection connection = (BezierConnection)BezierConnection.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(key)).getOrThrow();
            if (isNewFormat) {
                SimpleConnection fromAbsolute = new SimpleConnection(connection.getFromPos().pos().offset((Vec3i)referencePos), connection.getFromPos().direction());
                SimpleConnection toAbsolute = connection.getToPos() != null ? new SimpleConnection(connection.getToPos().pos().offset((Vec3i)referencePos), connection.getToPos().direction()) : null;
                return new BezierConnection(fromAbsolute, toAbsolute, connection.getTubeSegments(), connection.getCachedRelativeBezierPoints());
            }
            SimpleConnection fromPos = connection.getFromPos();
            SimpleConnection toPos = connection.getToPos();
            int tubeSegments = connection.getTubeSegments();
            int detailLevel = toPos != null ? (int)Math.max(3.0, fromPos.pos().getCenter().distanceTo(toPos.pos().getCenter())) : 0;
            return new BezierConnection(fromPos, toPos, tubeSegments, detailLevel);
        }
        catch (Exception ignored) {
            try {
                SimpleConnection connection = (SimpleConnection)SimpleConnection.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(key)).getOrThrow();
                if (isNewFormat) {
                    return new SimpleConnection(connection.pos().offset((Vec3i)referencePos), connection.direction());
                }
                return connection;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    default public void writeConnectionRelative(CompoundTag tag, BlockPos referencePos, Tuple<IConnection, String> ... connections) {
        for (Tuple<IConnection, String> connection : connections) {
            this.writeConnectionRelativeSingle(tag, referencePos, (IConnection)connection.getA(), (String)connection.getB());
            tag.putInt((String)connection.getB() + "_version", 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public void writeConnectionRelativeSingle(CompoundTag tag, BlockPos referencePos, IConnection connection, String key) {
        if (connection instanceof SimpleConnection) {
            SimpleConnection relative;
            SimpleConnection simpleConnection = (SimpleConnection)connection;
            try {
                BlockPos blockPos;
                BlockPos pos = blockPos = simpleConnection.pos();
                BlockPos direction = blockPos = simpleConnection.direction();
                relative = new SimpleConnection(pos.subtract((Vec3i)referencePos), (Direction)direction);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            tag.put(key, (Tag)SimpleConnection.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)relative).getOrThrow());
            return;
        }
        if (!(connection instanceof BezierConnection)) return;
        BezierConnection bezierConnection = (BezierConnection)connection;
        SimpleConnection fromRelative = new SimpleConnection(bezierConnection.getFromPos().pos().subtract((Vec3i)referencePos), bezierConnection.getFromPos().direction());
        SimpleConnection toRelative = bezierConnection.getToPos() != null ? new SimpleConnection(bezierConnection.getToPos().pos().subtract((Vec3i)referencePos), bezierConnection.getToPos().direction()) : null;
        BezierConnection relative = new BezierConnection(fromRelative, toRelative, bezierConnection.getTubeSegments(), bezierConnection.getCachedRelativeBezierPoints());
        tag.put(key, (Tag)BezierConnection.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)relative).getOrThrow());
    }

    @Nullable
    public IConnection getConnectionInDirection(Direction var1);

    @Nullable
    public IConnection getThisConnectionFrom(SimpleConnection var1);

    public boolean hasConnectionAvailable();

    public boolean isConnected();

    public void setConnection(IConnection var1, Direction var2);

    public void clearConnection(IConnection var1);

    public int blockBroken();

    default public int blockBroken(Level level, IConnection connection, BlockPos selfPos) {
        BlockEntity otherBlock;
        int toDrop = 0;
        BezierConnection thisEntranceConnection = connection.getThisEntranceConnection(level);
        if (thisEntranceConnection != null) {
            toDrop += (int)thisEntranceConnection.distance();
        }
        IConnection connectionToClear = null;
        BlockPos otherBlockPos = null;
        if (connection instanceof BezierConnection) {
            BezierConnection bezier = (BezierConnection)connection;
            SimpleConnection connectionTo = bezier.getToPos();
            SimpleConnection connectionFrom = bezier.getFromPos();
            if (connectionTo.pos().equals((Object)selfPos)) {
                connectionToClear = connection;
                otherBlockPos = connectionFrom.pos();
            } else if (connectionFrom.pos().equals((Object)selfPos)) {
                connectionToClear = connectionFrom;
                otherBlockPos = connectionTo.pos();
            }
        } else if (connection instanceof SimpleConnection) {
            SimpleConnection simple = (SimpleConnection)connection;
            if (simple.pos().equals((Object)selfPos)) {
                try {
                    throw new TubeConnectionException("SimpleConnection should not be used here, use BezierConnection instead.", connection);
                }
                catch (TubeConnectionException e) {
                    HypertubeMod.LOGGER.error(e.getMessage());
                    return 0;
                }
            }
            otherBlockPos = simple.pos();
            connectionToClear = thisEntranceConnection;
        }
        if (connectionToClear != null && (otherBlock = level.getBlockEntity(otherBlockPos)) instanceof ITubeConnectionEntity) {
            ITubeConnectionEntity tubeConnection = (ITubeConnectionEntity)otherBlock;
            tubeConnection.clearConnection(connectionToClear);
        }
        return toDrop;
    }

    public List<Direction> getFacesConnectable();

    public List<IConnection> getConnections();

    public boolean wrenchClicked(Direction var1);

    @Nullable
    public Vec3 getExitDirection();
}

