/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.travel;

import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TravelPathData {
    private final List<Vec3> travelPoints = new ArrayList<Vec3>();
    private final List<UUID> bezierConnections = new ArrayList<UUID>();
    private final List<BlockPos> blockConnections = new ArrayList<BlockPos>();
    private final Set<BlockPos> actionPoints = new HashSet<BlockPos>();

    public TravelPathData(BlockPos firstPipe, Level level, BlockPos entrancePos) {
        this.travelPoints.add(entrancePos.getCenter());
        this.blockConnections.add(entrancePos);
        this.travelPoints.add(firstPipe.getCenter());
        this.blockConnections.add(firstPipe);
        this.addTravelPoint(entrancePos, level);
        this.addTravelPoint(firstPipe, level);
        this.checkAndRemoveNearPoints();
    }

    private void checkAndRemoveNearPoints() {
        if (this.travelPoints.size() < 2) {
            return;
        }
        Vec3 lastPoint = this.travelPoints.getFirst();
        for (int i = 1; i < this.travelPoints.size(); ++i) {
            Vec3 currentPoint = this.travelPoints.get(i);
            double distance = lastPoint.distanceToSqr(currentPoint);
            if (distance < 0.8) {
                this.travelPoints.remove(i);
                --i;
                continue;
            }
            lastPoint = currentPoint;
        }
    }

    private void addTravelPoint(BlockPos pos, Level level) {
        ActionTubeBlockEntity tubeEntity;
        BlockEntity blockEntity;
        BlockState blockState = level.getBlockState(pos);
        if (level.getBlockState(pos).getBlock() instanceof ITubeActionPoint || (blockEntity = level.getBlockEntity(pos)) instanceof ActionTubeBlockEntity && (tubeEntity = (ActionTubeBlockEntity)blockEntity).hasAnyTubeAttachment()) {
            this.actionPoints.add(pos);
        }
        if (this.addCurvedTravelPoint(pos, level)) {
            return;
        }
        Block block = blockState.getBlock();
        if (!(block instanceof ITubeConnection)) {
            return;
        }
        ITubeConnection pipeBlock = (ITubeConnection)block;
        List<Direction> connectedFaces = pipeBlock.getConnectedFaces(blockState);
        for (Direction direction : connectedFaces) {
            ITubeConnectionEntity tubeEntity2;
            BlockEntity blockEntity2;
            ITubeConnection connection;
            Block block2;
            BlockPos nextPipe = pos.relative(direction);
            if (this.blockConnections.contains(nextPipe) || !((block2 = level.getBlockState(nextPipe).getBlock()) instanceof ITubeConnection) || !(connection = (ITubeConnection)block2).canTravelConnect((LevelAccessor)level, nextPipe, direction) && (blockEntity2 = level.getBlockEntity(nextPipe)) instanceof ITubeConnectionEntity && !(tubeEntity2 = (ITubeConnectionEntity)blockEntity2).isConnected()) continue;
            this.travelPoints.add(nextPipe.getCenter());
            this.blockConnections.add(nextPipe);
            this.addTravelPoint(nextPipe, level);
            break;
        }
    }

    private boolean addCurvedTravelPoint(BlockPos pos, Level level) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return false;
        }
        ITubeConnectionEntity hypertubeBlockEntity = (ITubeConnectionEntity)blockEntity;
        boolean connected = false;
        for (IConnection connection : hypertubeBlockEntity.getConnections()) {
            ActionTubeBlockEntity tubeEntity;
            BlockEntity blockEntity2;
            BlockPos fromPosFinal;
            BlockPos currentFromPos;
            BezierConnection bezier;
            boolean inverse = false;
            if (connection instanceof SimpleConnection) {
                BezierConnection fromTubeBezier;
                ITubeConnectionEntity fromTube;
                IConnection fromTubeConn;
                SimpleConnection simple = (SimpleConnection)connection;
                BlockEntity blockEntity3 = level.getBlockEntity(simple.pos());
                if (!(blockEntity3 instanceof ITubeConnectionEntity) || !((fromTubeConn = (fromTube = (ITubeConnectionEntity)blockEntity3).getThisConnectionFrom(simple)) instanceof BezierConnection)) continue;
                bezier = fromTubeBezier = (BezierConnection)fromTubeConn;
                inverse = true;
                currentFromPos = simple.pos();
            } else {
                BezierConnection bezierConnection;
                if (!(connection instanceof BezierConnection)) continue;
                bezier = bezierConnection = (BezierConnection)connection;
                currentFromPos = pos;
            }
            if (this.bezierConnections.contains(bezier.getUuid())) continue;
            ArrayList<Vec3> bezierPoints = new ArrayList<Vec3>(bezier.getBezierPoints(level, currentFromPos));
            if (inverse) {
                Collections.reverse(bezierPoints);
            }
            bezierPoints.removeLast();
            bezierPoints.removeFirst();
            this.travelPoints.addAll(bezierPoints);
            this.bezierConnections.add(bezier.getUuid());
            BlockPos storedFromPos = bezier.getFromPos().pos();
            SimpleConnection toConnection = bezier.getToPos();
            if (toConnection == null) continue;
            BlockPos storedToPos = toConnection.pos();
            BlockPos offset = storedToPos.subtract((Vec3i)storedFromPos);
            BlockPos currentToPos = currentFromPos.offset((Vec3i)offset);
            BlockPos toPosFinal = inverse ? currentFromPos : currentToPos;
            BlockPos blockPos = fromPosFinal = inverse ? currentToPos : currentFromPos;
            if (!this.blockConnections.contains(fromPosFinal)) {
                this.blockConnections.add(fromPosFinal);
                if (level.getBlockState(fromPosFinal).getBlock() instanceof ITubeActionPoint || (blockEntity2 = level.getBlockEntity(fromPosFinal)) instanceof ActionTubeBlockEntity && (tubeEntity = (ActionTubeBlockEntity)blockEntity2).hasAnyTubeAttachment()) {
                    this.actionPoints.add(fromPosFinal);
                }
            }
            if (!this.blockConnections.contains(toPosFinal)) {
                this.blockConnections.add(toPosFinal);
                if (level.getBlockState(toPosFinal).getBlock() instanceof ITubeActionPoint || (blockEntity2 = level.getBlockEntity(toPosFinal)) instanceof ActionTubeBlockEntity && (tubeEntity = (ActionTubeBlockEntity)blockEntity2).hasAnyTubeAttachment()) {
                    this.actionPoints.add(toPosFinal);
                }
            }
            this.addTravelPoint(toPosFinal, level);
            connected = true;
        }
        return connected;
    }

    public BlockPos getLastBlockPos() {
        if (this.blockConnections.isEmpty()) {
            return null;
        }
        return this.blockConnections.getLast();
    }

    public Vec3 getEndDirection(Level level) {
        if (this.blockConnections.isEmpty()) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.blockConnections.getLast());
        if (blockEntity instanceof ITubeConnectionEntity) {
            ITubeConnectionEntity connection = (ITubeConnectionEntity)blockEntity;
            return connection.getExitDirection();
        }
        return null;
    }

    public List<Vec3> getTravelPoints() {
        return this.travelPoints;
    }

    public Set<BlockPos> getActionPoints() {
        return this.actionPoints;
    }
}

