/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.items;

import com.pedrorok.hypertube.blocks.ActionTubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.core.smarttube.ITubeAttachment;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TubeAttachmentItem
extends Item {
    private final String attachmentKey;

    public TubeAttachmentItem(String attachmentKey, Item.Properties pProperties) {
        super(pProperties);
        this.attachmentKey = attachmentKey;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = pContext.getPlayer();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player == null) {
            return super.useOn(pContext);
        }
        if (pContext.getHand() == InteractionHand.OFF_HAND) {
            return super.useOn(pContext);
        }
        Direction direction = pContext.getClickedFace();
        if (!(state.getBlock() instanceof ActionTubeBlock)) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ActionTubeBlockEntity)) {
            return InteractionResult.FAIL;
        }
        ActionTubeBlockEntity actionTubeBE = (ActionTubeBlockEntity)blockEntity;
        if (actionTubeBE.hasTubeAttachment(direction)) {
            return InteractionResult.FAIL;
        }
        if (!ActionTubeBlock.canPlaceAttachment(state, (BlockGetter)level, pos, direction)) {
            return InteractionResult.FAIL;
        }
        ITubeAttachment smartTube = this.getTubeAttachment();
        if (smartTube == null) {
            throw new NoSuchElementException("SmartTube attachment " + this.attachmentKey + " not found");
        }
        actionTubeBE.addTubeAttachment(direction, smartTube);
        pContext.getItemInHand().consume(1, (LivingEntity)player);
        IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
        return super.useOn(pContext);
    }

    public ITubeAttachment getTubeAttachment() {
        return ITubeAttachment.get(this.attachmentKey);
    }
}

