/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network.packets;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.core.travel.TravelManager;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record FinishPathPacket(UUID entityUuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FinishPathPacket> TYPE = new CustomPacketPayload.Type(HypertubeMod.of("finish_travel_path"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FinishPathPacket> STREAM_CODEC = StreamCodec.of(FinishPathPacket::encode, FinishPathPacket::decode);

    public static void encode(FriendlyByteBuf buf, FinishPathPacket packet) {
        buf.writeUUID(packet.entityUuid);
    }

    public static FinishPathPacket decode(FriendlyByteBuf buf) {
        return new FinishPathPacket(buf.readUUID());
    }

    public static void handle(FinishPathPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> TravelManager.finishTravel(packet.entityUuid));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

